/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.commerce.service.CommerceShippingMethodService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.BillingAddress;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.order.internal.helper.v1_0.OrderHelper;
import com.liferay.headless.commerce.admin.order.internal.odata.entity.v1_0.OrderEntityModel;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderResourceImpl;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.BillingAddressUtil;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.OrderItemUtil;
import com.liferay.headless.commerce.admin.order.internal.util.v1_0.ShippingAddressUtil;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order.properties"}, scope=ServiceScope.PROTOTYPE, service={OrderResource.class})
public class OrderResourceImpl
extends BaseOrderResourceImpl {
    private static final EntityModel _entityModel = new OrderEntityModel();
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private CommerceShippingMethodService _commerceShippingMethodService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private OrderHelper _orderHelper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOrder(Long id) throws Exception {
        this._commerceOrderService.deleteCommerceOrder(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOrderByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        this._commerceOrderService.deleteCommerceOrder(commerceOrder.getCommerceOrderId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Order getOrder(Long id) throws Exception {
        return this._orderHelper.toOrder(GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale(), this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextUser, this.contextUriInfo, this._getActions(this._commerceOrderService.getCommerceOrder(GetterUtil.getLong((Object)id))));
    }

    @Override
    public Order getOrderByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        return this._orderHelper.toOrder(commerceOrder.getCommerceOrderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextUser, this.contextUriInfo, this._getActions(commerceOrder));
    }

    @Override
    public Page<Order> getOrdersPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._orderHelper.getOrdersPage(this.contextCompany.getCompanyId(), filter, pagination, search, sorts, (UnsafeFunction<Document, Order, Exception>)((UnsafeFunction)document -> this._orderHelper.toOrder(GetterUtil.getLong((String)document.get("entryClassPK")), this.contextAcceptLanguage.getPreferredLocale(), this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextUser, this.contextUriInfo, this._getActions(this._commerceOrderService.getCommerceOrder(GetterUtil.getLong((Object)GetterUtil.getLong((String)document.get("entryClassPK"))))))), true);
    }

    @Override
    public Response patchOrder(Long id, Order order) throws Exception {
        this._updateOrder(this._commerceOrderService.getCommerceOrder(id.longValue()), order);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderByExternalReferenceCode(String externalReferenceCode, Order order) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        this._updateOrder(commerceOrder, order);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Order postOrder(Order order) throws Exception {
        CommerceOrder commerceOrder = this._addOrUpdateOrder(order);
        return this._orderHelper.toOrder(commerceOrder.getCommerceOrderId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextAcceptLanguage.isAcceptAllLanguages(), this.contextUser, this.contextUriInfo, this._getActions(commerceOrder));
    }

    private Map<String, String> _addAction(String actionId, long commerceOrderId, UriInfo uriInfo, String methodName, Class<?> clazz) throws NoSuchMethodException, PortalException {
        if (!this._commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrderId, actionId)) {
            return null;
        }
        return HashMapBuilder.put((Object)"href", () -> {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            return uriBuilder.path(this._getVersion(uriInfo)).path(clazz.getSuperclass(), methodName).toTemplate();
        }).put((Object)"method", (Object)this._getHttpMethodName(clazz, this._getMethod(clazz, methodName))).build();
    }

    private CommerceOrder _addOrUpdateOrder(Order order) throws Exception {
        Map customFields;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(order.getChannelId().longValue());
        long commerceShippingMethodId = 0L;
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.fetchCommerceShippingMethod(commerceChannel.getGroupId(), order.getShippingMethod());
        if (commerceShippingMethod != null) {
            commerceShippingMethodId = commerceShippingMethod.getCommerceShippingMethodId();
        }
        CommerceAccount commerceAccount = null;
        if (order.getAccountId() != null) {
            commerceAccount = this._commerceAccountService.getCommerceAccount(order.getAccountId().longValue());
        }
        if (commerceAccount == null && Validator.isNotNull((String)order.getAccountExternalReferenceCode())) {
            commerceAccount = this._commerceAccountService.fetchByExternalReferenceCode(commerceChannel.getCompanyId(), order.getAccountExternalReferenceCode());
        }
        if (commerceAccount == null) {
            throw new NoSuchAccountException();
        }
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(commerceChannel.getCompanyId(), order.getCurrencyCode());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceChannel.getGroupId());
        CommerceOrder commerceOrder = this._commerceOrderService.addOrUpdateCommerceOrder(order.getExternalReferenceCode(), commerceChannel.getGroupId(), GetterUtil.getLong((Object)order.getBillingAddressId()), commerceAccount.getCommerceAccountId(), commerceCurrency.getCommerceCurrencyId(), this._getCommerceOrderTypeId(order), commerceShippingMethodId, GetterUtil.getLong((Object)order.getShippingAddressId()), order.getAdvanceStatus(), order.getPaymentMethod(), GetterUtil.getInteger((Object)order.getOrderStatus(), (int)1), GetterUtil.getInteger((Object)order.getPaymentStatus(), (int)1), order.getPurchaseOrderNumber(), order.getShippingAmount(), order.getShippingOption(), order.getShippingWithTaxAmount(), order.getSubtotal(), order.getSubtotalWithTaxAmount(), order.getTaxAmount(), order.getTotal(), order.getTotalWithTaxAmount(), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), 0L, commerceAccount.getCommerceAccountId()), serviceContext);
        if (order.getOrderDate() != null) {
            Calendar orderDateCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
            orderDateCalendar.setTime(order.getOrderDate());
            DateConfig orderDate = new DateConfig(orderDateCalendar);
            this._commerceOrderService.updateOrderDate(commerceOrder.getCommerceOrderId(), orderDate.getMonth(), orderDate.getDay(), orderDate.getYear(), orderDate.getHour(), orderDate.getMinute(), serviceContext);
        }
        if (order.getRequestedDeliveryDate() != null) {
            Calendar requestedDeliveryDateCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
            requestedDeliveryDateCalendar.setTime(order.getRequestedDeliveryDate());
            DateConfig requestedDeliveryDate = new DateConfig(requestedDeliveryDateCalendar);
            this._commerceOrderService.updateInfo(commerceOrder.getCommerceOrderId(), GetterUtil.getString((String)order.getPrintedNote(), (String)commerceOrder.getPrintedNote()), requestedDeliveryDate.getMonth(), requestedDeliveryDate.getDay(), requestedDeliveryDate.getYear(), requestedDeliveryDate.getHour(), requestedDeliveryDate.getMinute(), serviceContext);
        } else {
            this._commerceOrderService.updatePrintedNote(commerceOrder.getCommerceOrderId(), GetterUtil.getString((String)order.getPrintedNote(), (String)commerceOrder.getPrintedNote()));
        }
        if (order.getDeliveryTermId() != null || order.getPaymentTermId() != null) {
            this._commerceOrderService.updateTermsAndConditions(commerceOrder.getCommerceOrderId(), GetterUtil.getLong((Object)order.getDeliveryTermId()), GetterUtil.getLong((Object)order.getPaymentTermId()), this.contextAcceptLanguage.getPreferredLanguageId());
        }
        if ((customFields = order.getCustomFields()) != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrder.class, (long)commerceOrder.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(order, commerceOrder, serviceContext);
    }

    private Map<String, Map<String, String>> _getActions(CommerceOrder commerceOrder) throws NoSuchMethodException, PortalException {
        if (this.contextUriInfo == null) {
            return Collections.emptyMap();
        }
        return HashMapBuilder.put((Object)"delete", this._addAction("DELETE", commerceOrder.getCommerceOrderId(), this.contextUriInfo, "deleteOrder", this.getClass())).put((Object)"get", this._addAction("VIEW", commerceOrder.getCommerceOrderId(), this.contextUriInfo, "getOrder", this.getClass())).put((Object)"update", this._addAction("UPDATE", commerceOrder.getCommerceOrderId(), this.contextUriInfo, "patchOrder", this.getClass())).build();
    }

    private long _getCommerceOrderTypeId(Order order) throws Exception {
        if (order.getOrderTypeId() != null) {
            return order.getOrderTypeId();
        }
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(order.getOrderTypeExternalReferenceCode(), this.contextCompany.getCompanyId());
        if (commerceOrderType != null) {
            return commerceOrderType.getCommerceOrderTypeId();
        }
        return 0L;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(OrderItem orderItem) {
        return CustomFieldsUtil.toMap(CommerceOrderItem.class.getName(), this.contextCompany.getCompanyId(), orderItem.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private String _getHttpMethodName(Class<?> clazz, Method method) throws NoSuchMethodException {
        Class<?> superClass = clazz.getSuperclass();
        Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
        for (Annotation annotation : superMethod.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Annotation[] annotations = annotationType.getAnnotationsByType(HttpMethod.class);
            if (annotations.length <= 0) continue;
            HttpMethod httpMethod = (HttpMethod)annotations[0];
            return httpMethod.value();
        }
        return null;
    }

    private Method _getMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private String[] _getOrderItemExternalReferenceCodes(OrderItem[] orderItems) {
        Stream<OrderItem> stream = Arrays.stream(orderItems);
        Object[] strings = (String[])stream.map(OrderItem::getExternalReferenceCode).filter(Objects::nonNull).distinct().toArray(String[]::new);
        if (ArrayUtil.isEmpty((Object[])strings)) {
            strings = null;
        }
        return strings;
    }

    private Long[] _getOrderItemIds(OrderItem[] orderItems) {
        Stream<OrderItem> stream = Arrays.stream(orderItems);
        Object[] longs = (Long[])stream.map(OrderItem::getId).filter(Objects::nonNull).distinct().toArray(Long[]::new);
        if (ArrayUtil.isEmpty((Object[])longs)) {
            longs = new Long[]{0L};
        }
        return longs;
    }

    private String _getVersion(UriInfo uriInfo) {
        String version = "";
        List matchedURIs = uriInfo.getMatchedURIs();
        if (!matchedURIs.isEmpty()) {
            version = (String)matchedURIs.get(matchedURIs.size() - 1);
        }
        return version;
    }

    private CommerceOrder _updateNestedResources(Order order, CommerceOrder commerceOrder, ServiceContext serviceContext) throws Exception {
        ShippingAddress shippingAddress;
        BillingAddress billingAddress;
        OrderItem[] orderItems = order.getOrderItems();
        if (orderItems != null) {
            this._commerceOrderItemService.deleteMissingCommerceOrderItems(commerceOrder.getCommerceOrderId(), this._getOrderItemIds(orderItems), this._getOrderItemExternalReferenceCodes(orderItems));
            for (OrderItem orderItem : orderItems) {
                CommerceOrderItem commerceOrderItem = OrderItemUtil.addOrUpdateCommerceOrderItem(this._cpInstanceService, this._commerceOrderItemService, this._commerceOrderModelResourcePermission, orderItem, commerceOrder, this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId()), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
                Map<String, Serializable> expandoAttributes = this._getExpandoBridgeAttributes(orderItem);
                if (!MapUtil.isNotEmpty(expandoAttributes)) continue;
                ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrderItem.class, (long)commerceOrderItem.getPrimaryKey(), expandoAttributes);
            }
        }
        if ((billingAddress = order.getBillingAddress()) != null) {
            commerceOrder = BillingAddressUtil.addOrUpdateBillingAddress(this._commerceAddressService, this._commerceOrderService, commerceOrder, billingAddress, serviceContext);
        }
        if ((shippingAddress = order.getShippingAddress()) != null) {
            commerceOrder = ShippingAddressUtil.addOrUpdateShippingAddress(this._commerceAddressService, this._commerceOrderService, commerceOrder, shippingAddress, serviceContext);
        }
        return commerceOrder;
    }

    private CommerceOrder _updateOrder(CommerceOrder commerceOrder, Order order) throws Exception {
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodService.fetchCommerceShippingMethod(commerceOrder.getGroupId(), order.getShippingMethod());
        if (commerceShippingMethod != null) {
            commerceShippingMethodId = commerceShippingMethod.getCommerceShippingMethodId();
        }
        commerceOrder = this._commerceOrderEngine.updateCommerceOrder(GetterUtil.getString((String)order.getExternalReferenceCode(), (String)commerceOrder.getExternalReferenceCode()), commerceOrder.getCommerceOrderId(), GetterUtil.getLong((Object)order.getBillingAddressId(), (long)commerceOrder.getBillingAddressId()), commerceShippingMethodId, GetterUtil.getLong((Object)order.getShippingAddressId(), (long)commerceOrder.getShippingAddressId()), GetterUtil.getString((String)order.getAdvanceStatus(), (String)commerceOrder.getAdvanceStatus()), GetterUtil.getString((String)order.getPaymentMethod(), (String)commerceOrder.getCommercePaymentMethodKey()), GetterUtil.getString((String)order.getPurchaseOrderNumber(), (String)commerceOrder.getPurchaseOrderNumber()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingAmount(), (Number)commerceOrder.getShippingAmount()), GetterUtil.getString((String)order.getShippingOption(), (String)commerceOrder.getShippingOptionName()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingWithTaxAmount(), (Number)commerceOrder.getShippingWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotal(), (Number)commerceOrder.getSubtotal()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalWithTaxAmount(), (Number)commerceOrder.getSubtotalWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTaxAmount(), (Number)commerceOrder.getTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotal(), (Number)commerceOrder.getTotal()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountAmount(), (Number)commerceOrder.getTotalDiscountAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalWithTaxAmount(), (Number)commerceOrder.getTotalWithTaxAmount()), this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), 0L, GetterUtil.getLong((Object)order.getAccountId(), (long)commerceOrder.getCommerceAccountId())), false);
        this._commerceOrderService.updateCommerceOrderPrices(commerceOrder.getCommerceOrderId(), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingAmount(), (Number)commerceOrder.getShippingAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountAmount(), (Number)commerceOrder.getShippingDiscountAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel1(), (Number)commerceOrder.getShippingDiscountPercentageLevel1()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel2(), (Number)commerceOrder.getShippingDiscountPercentageLevel2()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel3(), (Number)commerceOrder.getShippingDiscountPercentageLevel3()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel4(), (Number)commerceOrder.getShippingDiscountPercentageLevel4()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingDiscountWithTaxAmount(), (Number)commerceOrder.getShippingDiscountWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getShippingWithTaxAmount(), (Number)commerceOrder.getShippingWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotal(), (Number)commerceOrder.getSubtotal()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountAmount(), (Number)commerceOrder.getSubtotalDiscountAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel1(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel1()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel2(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel2()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel3(), (Number)commerceOrder.getTotalDiscountPercentageLevel3()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel4(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel4()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalDiscountWithTaxAmount(), (Number)commerceOrder.getSubtotalDiscountWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getSubtotalWithTaxAmount(), (Number)commerceOrder.getSubtotalWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTaxAmount(), (Number)commerceOrder.getTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotal(), (Number)commerceOrder.getTotal()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountAmount(), (Number)commerceOrder.getTotalDiscountAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel1(), (Number)commerceOrder.getTotalDiscountPercentageLevel1()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel2(), (Number)commerceOrder.getTotalDiscountPercentageLevel2()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel3(), (Number)commerceOrder.getTotalDiscountPercentageLevel3()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel4(), (Number)commerceOrder.getTotalDiscountPercentageLevel4()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel1(), (Number)commerceOrder.getTotalDiscountPercentageLevel1()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel2(), (Number)commerceOrder.getTotalDiscountPercentageLevel2()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel3(), (Number)commerceOrder.getTotalDiscountPercentageLevel3()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountPercentageLevel4(), (Number)commerceOrder.getTotalDiscountPercentageLevel4()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalDiscountWithTaxAmount(), (Number)commerceOrder.getTotalDiscountWithTaxAmount()), (BigDecimal)GetterUtil.getNumber((Object)order.getTotalWithTaxAmount(), (Number)commerceOrder.getTotalWithTaxAmount()));
        if (order.getRequestedDeliveryDate() != null) {
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId());
            Calendar requestedDeliveryDateCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
            requestedDeliveryDateCalendar.setTime(order.getRequestedDeliveryDate());
            DateConfig requestedDeliveryDate = new DateConfig(requestedDeliveryDateCalendar);
            commerceOrder = this._commerceOrderService.updateInfo(commerceOrder.getCommerceOrderId(), GetterUtil.getString((String)order.getPrintedNote(), (String)commerceOrder.getPrintedNote()), requestedDeliveryDate.getMonth(), requestedDeliveryDate.getDay(), requestedDeliveryDate.getYear(), requestedDeliveryDate.getHour(), requestedDeliveryDate.getMinute(), serviceContext);
        } else {
            commerceOrder = this._commerceOrderService.updatePrintedNote(commerceOrder.getCommerceOrderId(), GetterUtil.getString((String)order.getPrintedNote(), (String)commerceOrder.getPrintedNote()));
        }
        Map customFields = order.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrder.class, (long)commerceOrder.getPrimaryKey(), (Map)customFields);
        }
        commerceOrder = this._updateNestedResources(order, commerceOrder, this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
        if (Validator.isNotNull((Object)order.getOrderStatus()) && commerceOrder.getOrderStatus() != order.getOrderStatus().intValue()) {
            commerceOrder = this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, order.getOrderStatus().intValue(), this.contextUser.getUserId());
        }
        return commerceOrder;
    }
}

