/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleAccount;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.AccountDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.AccountResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class, NestedFieldSupport.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl
implements NestedFieldSupport {
    @Reference
    private AccountDTOConverter _accountDTOConverter;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private COREntryRelService _corEntryRelService;

    @Override
    public Account getOrderByExternalReferenceCodeAccount(String externalReferenceCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find order with external reference code " + externalReferenceCode);
        }
        return this._toAccount(commerceOrder.getCommerceAccountId());
    }

    @Override
    @NestedField(parentClass=Order.class, value="account")
    public Account getOrderIdAccount(Long id) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(id.longValue());
        return this._toAccount(commerceOrder.getCommerceAccountId());
    }

    @Override
    @NestedField(parentClass=OrderRuleAccount.class, value="account")
    public Account getOrderRuleAccountAccount(Long id) throws Exception {
        COREntryRel corEntryRel = this._corEntryRelService.getCOREntryRel(id.longValue());
        CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(corEntryRel.getClassPK());
        return this._toAccount(commerceAccount.getCommerceAccountId());
    }

    private Account _toAccount(long commerceAccountId) throws Exception {
        return this._accountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAccountId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

