/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.helper.v1_0;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderDTOConverter;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OrderHelper.class})
public class OrderHelper {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderDTOConverter _orderDTOConverter;

    public Page<Order> getOrdersPage(final long companyId, Filter filter, Pagination pagination, String search, Sort[] sorts, UnsafeFunction<Document, Order, Exception> transformUnsafeFunction, final boolean useSearchResultPermissionFilter) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceOrder.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setAttribute("useSearchResultPermissionFilter", (Serializable)Boolean.valueOf(useSearchResultPermissionFilter));
                searchContext.setCompanyId(companyId);
                long[] commerceChannelGroupIds = OrderHelper.this._getCommerceChannelGroupIds(companyId);
                if (commerceChannelGroupIds != null && commerceChannelGroupIds.length > 0) {
                    searchContext.setGroupIds(commerceChannelGroupIds);
                }
            }
        }, (Sort[])sorts, transformUnsafeFunction);
    }

    public Order toOrder(long commerceOrderId, Locale locale) throws Exception {
        return this._orderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderId, locale));
    }

    public Order toOrder(long commerceOrderId, Locale locale, boolean acceptAllLanguages, User contextUser, UriInfo contextUriInfo, Map<String, Map<String, String>> actions) throws Exception {
        return this._orderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(acceptAllLanguages, actions, this._dtoConverterRegistry, (Object)commerceOrderId, locale, contextUriInfo, contextUser));
    }

    private long[] _getCommerceChannelGroupIds(long companyId) throws Exception {
        List commerceChannels = this._commerceChannelLocalService.getCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        return stream.mapToLong(CommerceChannel::getGroupId).toArray();
    }
}

