/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderType;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceOrderType"}, service={DTOConverter.class, OrderTypeDTOConverter.class})
public class OrderTypeDTOConverter
implements DTOConverter<CommerceOrderType, OrderType> {
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private Language _language;

    public String getContentType() {
        return OrderType.class.getSimpleName();
    }

    public OrderType toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrderType commerceOrderType = this._commerceOrderTypeService.getCommerceOrderType(((Long)dtoConverterContext.getId()).longValue());
        final ExpandoBridge expandoBridge = commerceOrderType.getExpandoBridge();
        return new OrderType(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = commerceOrderType.isActive();
                this.customFields = expandoBridge.getAttributes();
                this.description = LanguageUtils.getLanguageIdMap((Map)commerceOrderType.getDescriptionMap());
                this.displayDate = commerceOrderType.getDisplayDate();
                this.displayOrder = commerceOrderType.getDisplayOrder();
                this.expirationDate = commerceOrderType.getExpirationDate();
                this.externalReferenceCode = commerceOrderType.getExternalReferenceCode();
                this.id = commerceOrderType.getCommerceOrderTypeId();
                this.name = LanguageUtils.getLanguageIdMap((Map)commerceOrderType.getNameMap());
                this.workflowStatusInfo = OrderTypeDTOConverter.this._toStatus(WorkflowConstants.getStatusLabel((int)commerceOrderType.getStatus()), OrderTypeDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), WorkflowConstants.getStatusLabel((int)commerceOrderType.getStatus())), commerceOrderType.getStatus());
            }
        };
    }

    private Status _toStatus(final String orderTypeStatusLabel, final String orderTypeStatusLabelI18n, final int statusCode) {
        return new Status(){
            {
                this.code = statusCode;
                this.label = orderTypeStatusLabel;
                this.label_i18n = orderTypeStatusLabelI18n;
            }
        };
    }
}

