/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.CPMeasurementUnitService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={DTOConverter.class, OrderItemDTOConverter.class})
public class OrderItemDTOConverter
implements DTOConverter<CommerceOrderItem, OrderItem> {
    @Reference
    private CommerceOrderItemQuantityFormatter _commerceOrderItemQuantityFormatter;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CPMeasurementUnitService _cpMeasurementUnitService;

    public String getContentType() {
        return OrderItem.class.getSimpleName();
    }

    public OrderItem toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(((Long)dtoConverterContext.getId()).longValue());
        final CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        final CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        return new OrderItem(){
            {
                this.bookedQuantityId = commerceOrderItem.getBookedQuantityId();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CommerceOrderItem.class.getName(), commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getCompanyId(), dtoConverterContext.getLocale());
                this.decimalQuantity = commerceOrderItem.getDecimalQuantity();
                this.deliveryGroup = commerceOrderItem.getDeliveryGroup();
                this.discountAmount = commerceOrderItem.getDiscountAmount();
                this.discountManuallyAdjusted = commerceOrderItem.isDiscountManuallyAdjusted();
                this.discountPercentageLevel1 = commerceOrderItem.getDiscountPercentageLevel1();
                this.discountPercentageLevel1WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount();
                this.discountPercentageLevel2 = commerceOrderItem.getDiscountPercentageLevel2();
                this.discountPercentageLevel2WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount();
                this.discountPercentageLevel3 = commerceOrderItem.getDiscountPercentageLevel3();
                this.discountPercentageLevel3WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount();
                this.discountPercentageLevel4 = commerceOrderItem.getDiscountPercentageLevel4();
                this.discountPercentageLevel4WithTaxAmount = commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount();
                this.discountWithTaxAmount = commerceOrderItem.getDiscountWithTaxAmount();
                this.externalReferenceCode = commerceOrderItem.getExternalReferenceCode();
                this.finalPrice = commerceOrderItem.getFinalPrice();
                this.finalPriceWithTaxAmount = commerceOrderItem.getFinalPriceWithTaxAmount();
                this.formattedQuantity = OrderItemDTOConverter.this._commerceOrderItemQuantityFormatter.format(commerceOrderItem, dtoConverterContext.getLocale());
                this.id = commerceOrderItem.getCommerceOrderItemId();
                this.name = LanguageUtils.getLanguageIdMap((Map)commerceOrderItem.getNameMap());
                this.options = commerceOrderItem.getJson();
                this.orderExternalReferenceCode = commerceOrder.getExternalReferenceCode();
                this.orderId = commerceOrder.getCommerceOrderId();
                this.priceManuallyAdjusted = commerceOrderItem.isPriceManuallyAdjusted();
                this.printedNote = commerceOrderItem.getPrintedNote();
                this.promoPrice = commerceOrderItem.getPromoPrice();
                this.promoPriceWithTaxAmount = commerceOrderItem.getPromoPriceWithTaxAmount();
                this.quantity = commerceOrderItem.getQuantity();
                this.requestedDeliveryDate = commerceOrderItem.getRequestedDeliveryDate();
                this.shippedQuantity = commerceOrderItem.getShippedQuantity();
                this.shippingAddressId = commerceOrderItem.getShippingAddressId();
                this.sku = commerceOrderItem.getSku();
                this.skuExternalReferenceCode = OrderItemDTOConverter.this._getSkuExternalReferenceCode(cpInstance);
                this.skuId = OrderItemDTOConverter.this._getSkuId(cpInstance);
                this.subscription = commerceOrderItem.isSubscription();
                this.unitPrice = commerceOrderItem.getUnitPrice();
                this.unitPriceWithTaxAmount = commerceOrderItem.getUnitPriceWithTaxAmount();
                this.setUnitOfMeasure(() -> {
                    if (commerceOrderItem.getCPMeasurementUnitId() <= 0L) {
                        return "";
                    }
                    CPMeasurementUnit cpMeasurementUnit = OrderItemDTOConverter.this._cpMeasurementUnitService.getCPMeasurementUnit(commerceOrderItem.getCPMeasurementUnitId());
                    return cpMeasurementUnit.getKey();
                });
            }
        };
    }

    private String _getSkuExternalReferenceCode(CPInstance cpInstance) {
        if (cpInstance == null) {
            return "";
        }
        return cpInstance.getExternalReferenceCode();
    }

    private Long _getSkuId(CPInstance cpInstance) {
        if (cpInstance == null) {
            return 0L;
        }
        return cpInstance.getCPInstanceId();
    }
}

