/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.util.v1_0;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.math.BigDecimal;
import java.util.Date;

public class OrderItemUtil {
    public static CommerceOrderItem upsertCommerceOrderItem(CPInstanceService cpInstanceService, CommerceOrderItemService commerceOrderItemService, OrderItem orderItem, CommerceOrder commerceOrder, CommerceContext commerceContext, ServiceContext serviceContext) throws Exception {
        ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
        CPInstance cpInstance = null;
        if (orderItem.getSkuId() != null) {
            cpInstance = cpInstanceService.getCPInstance(orderItem.getSkuId().longValue());
        }
        if (orderItem.getSkuExternalReferenceCode() != null) {
            cpInstance = cpInstanceService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), orderItem.getSkuExternalReferenceCode());
        }
        CommerceOrderItem commerceOrderItem = commerceOrderItemService.upsertCommerceOrderItem(commerceOrder.getCommerceOrderId(), cpInstance.getCPInstanceId(), GetterUtil.get((Object)orderItem.getQuantity(), (int)0), GetterUtil.get((Object)orderItem.getShippedQuantity(), (int)0), null, commerceContext, serviceContext);
        commerceOrderItem = commerceOrderItemService.updateCommerceOrderItemInfo(commerceOrderItem.getCommerceOrderItemId(), GetterUtil.get((String)orderItem.getDeliveryGroup(), (String)""), GetterUtil.get((Object)orderItem.getShippingAddressId(), (long)0L), GetterUtil.get((String)orderItem.getPrintedNote(), (String)""));
        Date requestedDeliveryDate = orderItem.getRequestedDeliveryDate();
        if (requestedDeliveryDate != null) {
            commerceOrderItem = commerceOrderItemService.updateCommerceOrderItemDeliveryDate(commerceOrderItem.getCommerceOrderItemId(), requestedDeliveryDate);
        }
        if (PortalPermissionUtil.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (String)"MANAGE_COMMERCE_ORDER_PRICES")) {
            commerceOrderItem = commerceOrderItemService.updateCommerceOrderItemPrices(commerceOrderItem.getCommerceOrderItemId(), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPrice(), (Number)commerceOrderItem.getUnitPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPrice(), (Number)commerceOrderItem.getPromoPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountAmount(), (Number)commerceOrderItem.getDiscountAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPrice(), (Number)commerceOrderItem.getFinalPrice()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1(), (Number)commerceOrderItem.getDiscountPercentageLevel1()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2(), (Number)commerceOrderItem.getDiscountPercentageLevel2()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3(), (Number)commerceOrderItem.getDiscountPercentageLevel3()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4(), (Number)commerceOrderItem.getDiscountPercentageLevel4()), (BigDecimal)GetterUtil.get((Object)orderItem.getUnitPriceWithTaxAmount(), (Number)commerceOrderItem.getUnitPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getPromoPriceWithTaxAmount(), (Number)commerceOrderItem.getPromoPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountWithTaxAmount(), (Number)commerceOrderItem.getDiscountWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getFinalPriceWithTaxAmount(), (Number)commerceOrderItem.getFinalPriceWithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel1WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel2WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel3WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount()), (BigDecimal)GetterUtil.get((Object)orderItem.getDiscountPercentageLevel4WithTaxAmount(), (Number)commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount()));
        }
        return commerceOrderItem;
    }
}

