/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.jaxrs.exception.mapper;

import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.headless.commerce.core.exception.mapper.BaseExceptionMapper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;

@Provider
@Component(enabled=false, property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.Headless.Commerce.Admin.Order)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.Headless.Commerce.Admin.Order.CommerceOrderValidatorException"}, service={ExceptionMapper.class})
public class CommerceOrderValidatorExceptionMapper
extends BaseExceptionMapper<CommerceOrderValidatorException> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderValidatorExceptionMapper.class);

    public String getErrorDescription() {
        return "Invalid order";
    }

    public Response.Status getStatus() {
        return Response.Status.BAD_REQUEST;
    }

    public Response toResponse(CommerceOrderValidatorException commerceOrderValidatorException) {
        _log.error((Object)"General REST exception", (Throwable)commerceOrderValidatorException);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)this.getStatus());
        Response.Status status = this.getStatus();
        responseBuilder.entity((Object)this.toJSON(this._getErrorMessage(commerceOrderValidatorException), status.getStatusCode(), new Object[0]));
        responseBuilder.type(MediaType.APPLICATION_JSON_TYPE);
        return responseBuilder.build();
    }

    private String _getErrorMessage(CommerceOrderValidatorException commerceOrderValidatorException) {
        List commerceOrderValidatorResults = commerceOrderValidatorException.getCommerceOrderValidatorResults();
        if (commerceOrderValidatorResults.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        sb.append("{");
        for (CommerceOrderValidatorResult commerceOrderValidatorResult : commerceOrderValidatorResults) {
            if (commerceOrderValidatorResults.indexOf(commerceOrderValidatorResult) > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(commerceOrderValidatorResult.getLocalizedMessage());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

