/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.CommerceOrderNoteService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderNote;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.model.CommerceOrderNote"}, service={DTOConverter.class, OrderNoteDTOConverter.class})
public class OrderNoteDTOConverter
implements DTOConverter<CommerceOrderNote, OrderNote> {
    @Reference
    private CommerceOrderNoteService _commerceOrderNoteService;
    @Reference
    private CommerceOrderService _commerceOrderService;

    public String getContentType() {
        return OrderNote.class.getSimpleName();
    }

    public OrderNote toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.getCommerceOrderNote(((Long)dtoConverterContext.getId()).longValue());
        final CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderNote.getCommerceOrderId());
        return new OrderNote(){
            {
                this.author = commerceOrderNote.getUserName();
                this.content = commerceOrderNote.getContent();
                this.externalReferenceCode = commerceOrderNote.getExternalReferenceCode();
                this.id = commerceOrderNote.getCommerceOrderNoteId();
                this.orderExternalReferenceCode = commerceOrder.getExternalReferenceCode();
                this.orderId = commerceOrder.getCommerceOrderId();
                this.restricted = commerceOrderNote.isRestricted();
            }
        };
    }
}

