/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Channel;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="OrderRuleChannel")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"channelId", "orderRuleId"})
@XmlRootElement(name="OrderRuleChannel")
public class OrderRuleChannel
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Channel channel;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String channelExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long channelId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long orderRuleChannelId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderRuleExternalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long orderRuleId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleChannel", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static OrderRuleChannel toDTO(String json) {
        return (OrderRuleChannel)ObjectMapperUtil.readValue(OrderRuleChannel.class, (String)json);
    }

    public static OrderRuleChannel unsafeToDTO(String json) {
        return (OrderRuleChannel)ObjectMapperUtil.unsafeReadValue(OrderRuleChannel.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @JsonIgnore
    public void setChannel(UnsafeSupplier<Channel, Exception> channelUnsafeSupplier) {
        try {
            this.channel = (Channel)channelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="DAB-34098-789-N")
    public String getChannelExternalReferenceCode() {
        return this.channelExternalReferenceCode;
    }

    public void setChannelExternalReferenceCode(String channelExternalReferenceCode) {
        this.channelExternalReferenceCode = channelExternalReferenceCode;
    }

    @JsonIgnore
    public void setChannelExternalReferenceCode(UnsafeSupplier<String, Exception> channelExternalReferenceCodeUnsafeSupplier) {
        try {
            this.channelExternalReferenceCode = (String)channelExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30324")
    public @DecimalMin(value="0") Long getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @JsonIgnore
    public void setChannelId(UnsafeSupplier<Long, Exception> channelIdUnsafeSupplier) {
        try {
            this.channelId = (Long)channelIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30643")
    public @DecimalMin(value="0") Long getOrderRuleChannelId() {
        return this.orderRuleChannelId;
    }

    public void setOrderRuleChannelId(Long orderRuleChannelId) {
        this.orderRuleChannelId = orderRuleChannelId;
    }

    @JsonIgnore
    public void setOrderRuleChannelId(UnsafeSupplier<Long, Exception> orderRuleChannelIdUnsafeSupplier) {
        try {
            this.orderRuleChannelId = (Long)orderRuleChannelIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="PAB-34098-789-N")
    public String getOrderRuleExternalReferenceCode() {
        return this.orderRuleExternalReferenceCode;
    }

    public void setOrderRuleExternalReferenceCode(String orderRuleExternalReferenceCode) {
        this.orderRuleExternalReferenceCode = orderRuleExternalReferenceCode;
    }

    @JsonIgnore
    public void setOrderRuleExternalReferenceCode(UnsafeSupplier<String, Exception> orderRuleExternalReferenceCodeUnsafeSupplier) {
        try {
            this.orderRuleExternalReferenceCode = (String)orderRuleExternalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getOrderRuleId() {
        return this.orderRuleId;
    }

    public void setOrderRuleId(Long orderRuleId) {
        this.orderRuleId = orderRuleId;
    }

    @JsonIgnore
    public void setOrderRuleId(UnsafeSupplier<Long, Exception> orderRuleIdUnsafeSupplier) {
        try {
            this.orderRuleId = (Long)orderRuleIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OrderRuleChannel)) {
            return false;
        }
        OrderRuleChannel orderRuleChannel = (OrderRuleChannel)object;
        return Objects.equals(this.toString(), orderRuleChannel.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(OrderRuleChannel._toJSON(this.actions));
        }
        if (this.channel != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channel\": ");
            sb.append(String.valueOf(this.channel));
        }
        if (this.channelExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderRuleChannel._escape(this.channelExternalReferenceCode));
            sb.append("\"");
        }
        if (this.channelId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelId\": ");
            sb.append((Object)this.channelId);
        }
        if (this.orderRuleChannelId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderRuleChannelId\": ");
            sb.append((Object)this.orderRuleChannelId);
        }
        if (this.orderRuleExternalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderRuleExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(OrderRuleChannel._escape(this.orderRuleExternalReferenceCode));
            sb.append("\"");
        }
        if (this.orderRuleId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderRuleId\": ");
            sb.append((Object)this.orderRuleId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(OrderRuleChannel._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (OrderRuleChannel._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(OrderRuleChannel._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(OrderRuleChannel._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

