/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseItem;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.WarehouseDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.odata.entity.v1_0.WarehouseEntityModel;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseWarehouseResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/warehouse.properties"}, scope=ServiceScope.PROTOTYPE, service={WarehouseResource.class})
public class WarehouseResourceImpl
extends BaseWarehouseResourceImpl {
    private static final EntityModel _entityModel = new WarehouseEntityModel();
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private WarehouseDTOConverter _warehouseDTOConverter;

    @Override
    public void deleteWarehouseByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        this._commerceInventoryWarehouseService.deleteCommerceInventoryWarehouse(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
    }

    @Override
    public void deleteWarehouseId(Long id) throws Exception {
        this._commerceInventoryWarehouseService.deleteCommerceInventoryWarehouse(id.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Warehouse getWarehouseByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        return this._toWarehouse(commerceInventoryWarehouse);
    }

    @Override
    public Warehouse getWarehouseId(Long id) throws Exception {
        return this._toWarehouse(GetterUtil.getLong((Object)id));
    }

    @Override
    public Page<Warehouse> getWarehousesPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceInventoryWarehouse.class.getName(), (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toWarehouse(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public Response patchWarehouseByExternalReferenceCode(String externalReferenceCode, Warehouse warehouse) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        this._updateWarehouse(commerceInventoryWarehouse, warehouse);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchWarehouseId(Long id, Warehouse warehouse) throws Exception {
        this._updateWarehouse(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(id.longValue()), warehouse);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Warehouse postWarehouse(Warehouse warehouse) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(warehouse.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        commerceInventoryWarehouse = commerceInventoryWarehouse == null ? this._commerceInventoryWarehouseService.addCommerceInventoryWarehouse(warehouse.getExternalReferenceCode(), LanguageUtils.getLocalizedMap((Map)warehouse.getName()), LanguageUtils.getLocalizedMap((Map)warehouse.getDescription()), GetterUtil.get((Object)warehouse.getActive(), (boolean)true), warehouse.getStreet1(), warehouse.getStreet2(), warehouse.getStreet3(), warehouse.getCity(), warehouse.getZip(), warehouse.getRegionISOCode(), warehouse.getCountryISOCode(), GetterUtil.get((Object)warehouse.getLatitude(), (double)0.0), GetterUtil.get((Object)warehouse.getLongitude(), (double)0.0), this._serviceContextHelper.getServiceContext()) : this._updateWarehouse(commerceInventoryWarehouse, warehouse);
        this._updateNestedResources(warehouse, commerceInventoryWarehouse);
        return this._toWarehouse(commerceInventoryWarehouse);
    }

    private Map<String, Map<String, String>> _getActions(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), "deleteWarehouseId", this._commerceInventoryWarehouseModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), "getWarehousesPage", this._commerceInventoryWarehouseModelResourcePermission)).put((Object)"permissions", this.addAction("PERMISSIONS", commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), "patchWarehouseId", this._commerceInventoryWarehouseModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), "patchWarehouseId", this._commerceInventoryWarehouseModelResourcePermission)).build();
    }

    private Warehouse _toWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        return this._warehouseDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceInventoryWarehouse), this._dtoConverterRegistry, (Object)commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private Warehouse _toWarehouse(long commerceInventoryWarehouseId) throws Exception {
        return this._toWarehouse(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId));
    }

    private void _updateNestedResources(Warehouse warehouse, CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        WarehouseItem[] warehouseItems = warehouse.getWarehouseItems();
        if (warehouseItems != null) {
            for (WarehouseItem warehouseItem : warehouseItems) {
                this._commerceInventoryWarehouseItemService.addOrUpdateCommerceInventoryWarehouseItem(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseItem.getSku(), warehouseItem.getQuantity().intValue());
            }
        }
    }

    private CommerceInventoryWarehouse _updateWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse, Warehouse warehouse) throws Exception {
        commerceInventoryWarehouse = this._commerceInventoryWarehouseService.updateCommerceInventoryWarehouse(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), LanguageUtils.getLocalizedMap((Map)warehouse.getName()), LanguageUtils.getLocalizedMap((Map)warehouse.getDescription()), GetterUtil.get((Object)warehouse.getActive(), (boolean)commerceInventoryWarehouse.isActive()), GetterUtil.get((String)warehouse.getStreet1(), (String)commerceInventoryWarehouse.getStreet1()), GetterUtil.get((String)warehouse.getStreet2(), (String)commerceInventoryWarehouse.getStreet2()), GetterUtil.get((String)warehouse.getStreet3(), (String)commerceInventoryWarehouse.getStreet3()), GetterUtil.get((String)warehouse.getCity(), (String)commerceInventoryWarehouse.getCity()), GetterUtil.get((String)warehouse.getZip(), (String)commerceInventoryWarehouse.getZip()), GetterUtil.get((String)warehouse.getRegionISOCode(), (String)commerceInventoryWarehouse.getCommerceRegionCode()), GetterUtil.get((String)warehouse.getCountryISOCode(), (String)commerceInventoryWarehouse.getCountryTwoLettersISOCode()), GetterUtil.get((Object)warehouse.getLatitude(), (double)commerceInventoryWarehouse.getLatitude()), GetterUtil.get((Object)warehouse.getLongitude(), (double)commerceInventoryWarehouse.getLongitude()), commerceInventoryWarehouse.getMvccVersion(), this._serviceContextHelper.getServiceContext());
        this._updateNestedResources(warehouse, commerceInventoryWarehouse);
        return commerceInventoryWarehouse;
    }
}

