/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0;

import com.liferay.commerce.inventory.exception.CommerceInventoryInvalidDateException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseItemException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseItemException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseItem;
import com.liferay.headless.commerce.admin.inventory.internal.dto.v1_0.WarehouseItemDTOConverter;
import com.liferay.headless.commerce.admin.inventory.internal.resource.v1_0.BaseWarehouseItemResourceImpl;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseItemResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/warehouse-item.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, WarehouseItemResource.class})
public class WarehouseItemResourceImpl
extends BaseWarehouseItemResourceImpl
implements NestedFieldSupport {
    private static final int _DEFAULT_INCREMENT_DAYS = 30;
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private WarehouseItemDTOConverter _warehouseItemDTOConverter;

    @Override
    public Response deleteWarehouseItem(Long id) throws Exception {
        this._commerceInventoryWarehouseItemService.deleteCommerceInventoryWarehouseItem(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteWarehouseItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouseItem == null) {
            throw new NoSuchInventoryWarehouseItemException("Unable to find warehouse item with external reference code " + externalReferenceCode);
        }
        this._commerceInventoryWarehouseItemService.deleteCommerceInventoryWarehouseItem(commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Page<WarehouseItem> getWarehouseByExternalReferenceCodeWarehouseItemsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        List commerceInventoryWarehouseItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItems(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItemsCount(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        return Page.of(this._toWarehouseItems(commerceInventoryWarehouseItems), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Warehouse.class, value="items")
    public Page<WarehouseItem> getWarehouseIdWarehouseItemsPage(Long id, Pagination pagination) throws Exception {
        List commerceInventoryWarehouseItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItems(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItemsCount(id.longValue());
        return Page.of(this._toWarehouseItems(commerceInventoryWarehouseItems), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public WarehouseItem getWarehouseItem(Long id) throws Exception {
        return this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public WarehouseItem getWarehouseItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouseItem == null) {
            throw new NoSuchInventoryWarehouseItemException("Unable to find warehouse item with external reference code " + externalReferenceCode);
        }
        return this._toWarehouseItem(commerceInventoryWarehouseItem);
    }

    @Override
    public Page<WarehouseItem> getWarehouseItemsUpdatedPage(Date end, Date start, Pagination pagination) throws Exception {
        if (start != null && end != null && start.compareTo(end) > 0) {
            throw new CommerceInventoryInvalidDateException("End date should be after start date");
        }
        if (start == null && end == null) {
            start = new Date();
        }
        if (start == null) {
            start = this._addDaysToDate(end, -30);
        }
        if (end == null) {
            end = this._addDaysToDate(start, 30);
        }
        List commerceInventoryWarehouseItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItemsCountByModifiedDate(this.contextCompany.getCompanyId(), start, end, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceInventoryWarehouseItemService.getCommerceInventoryWarehouseItemsCountByModifiedDate(this.contextCompany.getCompanyId(), start, end);
        return Page.of(this._toWarehouseItems(commerceInventoryWarehouseItems), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchWarehouseItem(Long id, WarehouseItem warehouseItem) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(warehouseItem.getWarehouseId().longValue());
        this._commerceInventoryWarehouseItemService.updateCommerceInventoryWarehouseItem(id.longValue(), GetterUtil.getInteger((Object)warehouseItem.getQuantity()), commerceInventoryWarehouse.getMvccVersion());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchWarehouseItemByExternalReferenceCode(String externalReferenceCode, WarehouseItem warehouseItem) throws Exception {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouseItem == null) {
            throw new NoSuchInventoryWarehouseItemException("Unable to find warehouse item with external reference code " + externalReferenceCode);
        }
        this._commerceInventoryWarehouseItemService.updateCommerceInventoryWarehouseItem(commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), GetterUtil.getInteger((Object)warehouseItem.getQuantity()), commerceInventoryWarehouseItem.getMvccVersion());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public WarehouseItem postWarehouseByExternalReferenceCodeWarehouseItem(String externalReferenceCode, WarehouseItem warehouseItem) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find warehouse with external reference code " + externalReferenceCode);
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.addCommerceInventoryWarehouseItem(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseItem.getSku(), warehouseItem.getQuantity().intValue());
        return this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public WarehouseItem postWarehouseIdWarehouseItem(Long id, WarehouseItem warehouseItem) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(id.longValue());
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.addCommerceInventoryWarehouseItem(warehouseItem.getExternalReferenceCode(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseItem.getSku(), warehouseItem.getQuantity().intValue());
        return this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public WarehouseItem postWarehouseItemByExternalReferenceCode(String externalReferenceCode, WarehouseItem warehouseItem) throws Exception {
        CommerceInventoryWarehouse commerceInventoryWarehouse = null;
        if (warehouseItem.getWarehouseId() != null) {
            commerceInventoryWarehouse = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(warehouseItem.getWarehouseId().longValue());
        } else if (warehouseItem.getWarehouseExternalReferenceCode() != null) {
            commerceInventoryWarehouse = this._commerceInventoryWarehouseService.fetchByExternalReferenceCode(warehouseItem.getWarehouseExternalReferenceCode(), this.contextUser.getCompanyId());
        }
        if (commerceInventoryWarehouse == null) {
            throw new NoSuchInventoryWarehouseException("Unable to find Warehouse");
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceInventoryWarehouseItem != null) {
            throw new DuplicateCommerceInventoryWarehouseItemException("External reference code already associated with this Warehouse");
        }
        commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemService.addCommerceInventoryWarehouseItem(externalReferenceCode, commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), warehouseItem.getSku(), warehouseItem.getQuantity().intValue());
        return this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Date _addDaysToDate(Date date, int increment) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, increment);
        return cal.getTime();
    }

    private WarehouseItem _toWarehouseItem(CommerceInventoryWarehouseItem commerceInventoryWarehouseItem) throws Exception {
        return this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<WarehouseItem> _toWarehouseItems(List<CommerceInventoryWarehouseItem> commerceInventoryWarehouseItems) throws Exception {
        ArrayList<WarehouseItem> warehouseItems = new ArrayList<WarehouseItem>();
        for (CommerceInventoryWarehouseItem commerceInventoryWarehouseItem : commerceInventoryWarehouseItems) {
            warehouseItems.add(this._warehouseItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return warehouseItems;
    }
}

