/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.client.serdes.v1_0;

import com.liferay.headless.commerce.admin.inventory.client.dto.v1_0.ReplenishmentItem;
import com.liferay.headless.commerce.admin.inventory.client.json.BaseJSONParser;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class ReplenishmentItemSerDes {
    public static ReplenishmentItem toDTO(String json) {
        ReplenishmentItemJSONParser replenishmentItemJSONParser = new ReplenishmentItemJSONParser();
        return (ReplenishmentItem)replenishmentItemJSONParser.parseToDTO(json);
    }

    public static ReplenishmentItem[] toDTOs(String json) {
        ReplenishmentItemJSONParser replenishmentItemJSONParser = new ReplenishmentItemJSONParser();
        return (ReplenishmentItem[])replenishmentItemJSONParser.parseToDTOs(json);
    }

    public static String toJSON(ReplenishmentItem replenishmentItem) {
        if (replenishmentItem == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (replenishmentItem.getAvailabilityDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availabilityDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(replenishmentItem.getAvailabilityDate()));
            sb.append("\"");
        }
        if (replenishmentItem.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(ReplenishmentItemSerDes._escape(replenishmentItem.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (replenishmentItem.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(replenishmentItem.getId());
        }
        if (replenishmentItem.getQuantity() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"quantity\": ");
            sb.append(replenishmentItem.getQuantity());
        }
        if (replenishmentItem.getSku() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(ReplenishmentItemSerDes._escape(replenishmentItem.getSku()));
            sb.append("\"");
        }
        if (replenishmentItem.getUnitOfMeasureKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"unitOfMeasureKey\": ");
            sb.append("\"");
            sb.append(ReplenishmentItemSerDes._escape(replenishmentItem.getUnitOfMeasureKey()));
            sb.append("\"");
        }
        if (replenishmentItem.getWarehouseId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseId\": ");
            sb.append(replenishmentItem.getWarehouseId());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        ReplenishmentItemJSONParser replenishmentItemJSONParser = new ReplenishmentItemJSONParser();
        return replenishmentItemJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(ReplenishmentItem replenishmentItem) {
        if (replenishmentItem == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (replenishmentItem.getAvailabilityDate() == null) {
            map.put("availabilityDate", null);
        } else {
            map.put("availabilityDate", liferayToJSONDateFormat.format(replenishmentItem.getAvailabilityDate()));
        }
        if (replenishmentItem.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(replenishmentItem.getExternalReferenceCode()));
        }
        if (replenishmentItem.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(replenishmentItem.getId()));
        }
        if (replenishmentItem.getQuantity() == null) {
            map.put("quantity", null);
        } else {
            map.put("quantity", String.valueOf(replenishmentItem.getQuantity()));
        }
        if (replenishmentItem.getSku() == null) {
            map.put("sku", null);
        } else {
            map.put("sku", String.valueOf(replenishmentItem.getSku()));
        }
        if (replenishmentItem.getUnitOfMeasureKey() == null) {
            map.put("unitOfMeasureKey", null);
        } else {
            map.put("unitOfMeasureKey", String.valueOf(replenishmentItem.getUnitOfMeasureKey()));
        }
        if (replenishmentItem.getWarehouseId() == null) {
            map.put("warehouseId", null);
        } else {
            map.put("warehouseId", String.valueOf(replenishmentItem.getWarehouseId()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            sb.append(ReplenishmentItemSerDes._toJSON(value));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _toJSON(Object value) {
        if (value instanceof Map) {
            return ReplenishmentItemSerDes._toJSON((Map)value);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder("[");
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                sb.append(ReplenishmentItemSerDes._toJSON(values[i]));
                if (i + 1 >= values.length) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (value instanceof String) {
            return "\"" + ReplenishmentItemSerDes._escape(value) + "\"";
        }
        return String.valueOf(value);
    }

    public static class ReplenishmentItemJSONParser
    extends BaseJSONParser<ReplenishmentItem> {
        @Override
        protected ReplenishmentItem createDTO() {
            return new ReplenishmentItem();
        }

        protected ReplenishmentItem[] createDTOArray(int size) {
            return new ReplenishmentItem[size];
        }

        @Override
        protected boolean parseMaps(String jsonParserFieldName) {
            if (Objects.equals(jsonParserFieldName, "availabilityDate")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "id")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "quantity")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "sku")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "unitOfMeasureKey")) {
                return false;
            }
            if (Objects.equals(jsonParserFieldName, "warehouseId")) {
                return false;
            }
            return false;
        }

        @Override
        protected void setField(ReplenishmentItem replenishmentItem, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "availabilityDate")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setAvailabilityDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "quantity")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setQuantity(new BigDecimal((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "sku")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setSku((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "unitOfMeasureKey")) {
                if (jsonParserFieldValue != null) {
                    replenishmentItem.setUnitOfMeasureKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "warehouseId") && jsonParserFieldValue != null) {
                replenishmentItem.setWarehouseId(Long.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

