/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.OrderType;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="WarehouseOrderType")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"orderTypeId", "warehouseId"})
@XmlRootElement(name="WarehouseOrderType")
public class WarehouseOrderType
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected OrderType orderType;
    @JsonIgnore
    private Supplier<OrderType> _orderTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderTypeExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _orderTypeExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long orderTypeId;
    @JsonIgnore
    private Supplier<Long> _orderTypeIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer priority;
    @JsonIgnore
    private Supplier<Integer> _prioritySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String warehouseExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _warehouseExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long warehouseId;
    @JsonIgnore
    private Supplier<Long> _warehouseIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long warehouseOrderTypeId;
    @JsonIgnore
    private Supplier<Long> _warehouseOrderTypeIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseOrderType", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WarehouseOrderType toDTO(String json) {
        return (WarehouseOrderType)ObjectMapperUtil.readValue(WarehouseOrderType.class, (String)json);
    }

    public static WarehouseOrderType unsafeToDTO(String json) {
        return (WarehouseOrderType)ObjectMapperUtil.unsafeReadValue(WarehouseOrderType.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public OrderType getOrderType() {
        if (this._orderTypeSupplier != null) {
            this.orderType = this._orderTypeSupplier.get();
            this._orderTypeSupplier = null;
        }
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        this._orderTypeSupplier = null;
    }

    @JsonIgnore
    public void setOrderType(UnsafeSupplier<OrderType, Exception> orderTypeUnsafeSupplier) {
        this._orderTypeSupplier = () -> {
            try {
                return (OrderType)orderTypeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="DAB-34098-789-N")
    public String getOrderTypeExternalReferenceCode() {
        if (this._orderTypeExternalReferenceCodeSupplier != null) {
            this.orderTypeExternalReferenceCode = this._orderTypeExternalReferenceCodeSupplier.get();
            this._orderTypeExternalReferenceCodeSupplier = null;
        }
        return this.orderTypeExternalReferenceCode;
    }

    public void setOrderTypeExternalReferenceCode(String orderTypeExternalReferenceCode) {
        this.orderTypeExternalReferenceCode = orderTypeExternalReferenceCode;
        this._orderTypeExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setOrderTypeExternalReferenceCode(UnsafeSupplier<String, Exception> orderTypeExternalReferenceCodeUnsafeSupplier) {
        this._orderTypeExternalReferenceCodeSupplier = () -> {
            try {
                return (String)orderTypeExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30324")
    public @DecimalMin(value="0") Long getOrderTypeId() {
        if (this._orderTypeIdSupplier != null) {
            this.orderTypeId = this._orderTypeIdSupplier.get();
            this._orderTypeIdSupplier = null;
        }
        return this.orderTypeId;
    }

    public void setOrderTypeId(Long orderTypeId) {
        this.orderTypeId = orderTypeId;
        this._orderTypeIdSupplier = null;
    }

    @JsonIgnore
    public void setOrderTypeId(UnsafeSupplier<Long, Exception> orderTypeIdUnsafeSupplier) {
        this._orderTypeIdSupplier = () -> {
            try {
                return (Long)orderTypeIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="1")
    public @DecimalMin(value="0") Integer getPriority() {
        if (this._prioritySupplier != null) {
            this.priority = this._prioritySupplier.get();
            this._prioritySupplier = null;
        }
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
        this._prioritySupplier = null;
    }

    @JsonIgnore
    public void setPriority(UnsafeSupplier<Integer, Exception> priorityUnsafeSupplier) {
        this._prioritySupplier = () -> {
            try {
                return (Integer)priorityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="PAB-34098-789-N")
    public String getWarehouseExternalReferenceCode() {
        if (this._warehouseExternalReferenceCodeSupplier != null) {
            this.warehouseExternalReferenceCode = this._warehouseExternalReferenceCodeSupplier.get();
            this._warehouseExternalReferenceCodeSupplier = null;
        }
        return this.warehouseExternalReferenceCode;
    }

    public void setWarehouseExternalReferenceCode(String warehouseExternalReferenceCode) {
        this.warehouseExternalReferenceCode = warehouseExternalReferenceCode;
        this._warehouseExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseExternalReferenceCode(UnsafeSupplier<String, Exception> warehouseExternalReferenceCodeUnsafeSupplier) {
        this._warehouseExternalReferenceCodeSupplier = () -> {
            try {
                return (String)warehouseExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getWarehouseId() {
        if (this._warehouseIdSupplier != null) {
            this.warehouseId = this._warehouseIdSupplier.get();
            this._warehouseIdSupplier = null;
        }
        return this.warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
        this._warehouseIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseId(UnsafeSupplier<Long, Exception> warehouseIdUnsafeSupplier) {
        this._warehouseIdSupplier = () -> {
            try {
                return (Long)warehouseIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30643")
    public @DecimalMin(value="0") Long getWarehouseOrderTypeId() {
        if (this._warehouseOrderTypeIdSupplier != null) {
            this.warehouseOrderTypeId = this._warehouseOrderTypeIdSupplier.get();
            this._warehouseOrderTypeIdSupplier = null;
        }
        return this.warehouseOrderTypeId;
    }

    public void setWarehouseOrderTypeId(Long warehouseOrderTypeId) {
        this.warehouseOrderTypeId = warehouseOrderTypeId;
        this._warehouseOrderTypeIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseOrderTypeId(UnsafeSupplier<Long, Exception> warehouseOrderTypeIdUnsafeSupplier) {
        this._warehouseOrderTypeIdSupplier = () -> {
            try {
                return (Long)warehouseOrderTypeIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WarehouseOrderType)) {
            return false;
        }
        WarehouseOrderType warehouseOrderType = (WarehouseOrderType)object;
        return Objects.equals(this.toString(), warehouseOrderType.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long warehouseOrderTypeId;
        Long warehouseId;
        String warehouseExternalReferenceCode;
        Integer priority;
        Long orderTypeId;
        String orderTypeExternalReferenceCode;
        OrderType orderType;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(WarehouseOrderType._toJSON(actions));
        }
        if ((orderType = this.getOrderType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderType\": ");
            sb.append(String.valueOf(orderType));
        }
        if ((orderTypeExternalReferenceCode = this.getOrderTypeExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderTypeExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseOrderType._escape(orderTypeExternalReferenceCode));
            sb.append("\"");
        }
        if ((orderTypeId = this.getOrderTypeId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderTypeId\": ");
            sb.append((Object)orderTypeId);
        }
        if ((priority = this.getPriority()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append((Object)priority);
        }
        if ((warehouseExternalReferenceCode = this.getWarehouseExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseOrderType._escape(warehouseExternalReferenceCode));
            sb.append("\"");
        }
        if ((warehouseId = this.getWarehouseId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseId\": ");
            sb.append((Object)warehouseId);
        }
        if ((warehouseOrderTypeId = this.getWarehouseOrderTypeId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseOrderTypeId\": ");
            sb.append((Object)warehouseOrderTypeId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WarehouseOrderType._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WarehouseOrderType._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WarehouseOrderType._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WarehouseOrderType._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WarehouseOrderType._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

