/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Channel;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="WarehouseChannel")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"channelId", "warehouseId"})
@XmlRootElement(name="WarehouseChannel")
public class WarehouseChannel
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Channel channel;
    @JsonIgnore
    private Supplier<Channel> _channelSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String channelExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _channelExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long channelId;
    @JsonIgnore
    private Supplier<Long> _channelIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long warehouseChannelId;
    @JsonIgnore
    private Supplier<Long> _warehouseChannelIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String warehouseExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _warehouseExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long warehouseId;
    @JsonIgnore
    private Supplier<Long> _warehouseIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseChannel", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WarehouseChannel toDTO(String json) {
        return (WarehouseChannel)ObjectMapperUtil.readValue(WarehouseChannel.class, (String)json);
    }

    public static WarehouseChannel unsafeToDTO(String json) {
        return (WarehouseChannel)ObjectMapperUtil.unsafeReadValue(WarehouseChannel.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Channel getChannel() {
        if (this._channelSupplier != null) {
            this.channel = this._channelSupplier.get();
            this._channelSupplier = null;
        }
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this._channelSupplier = null;
    }

    @JsonIgnore
    public void setChannel(UnsafeSupplier<Channel, Exception> channelUnsafeSupplier) {
        this._channelSupplier = () -> {
            try {
                return (Channel)channelUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="PAB-34098-789-N")
    public String getChannelExternalReferenceCode() {
        if (this._channelExternalReferenceCodeSupplier != null) {
            this.channelExternalReferenceCode = this._channelExternalReferenceCodeSupplier.get();
            this._channelExternalReferenceCodeSupplier = null;
        }
        return this.channelExternalReferenceCode;
    }

    public void setChannelExternalReferenceCode(String channelExternalReferenceCode) {
        this.channelExternalReferenceCode = channelExternalReferenceCode;
        this._channelExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setChannelExternalReferenceCode(UnsafeSupplier<String, Exception> channelExternalReferenceCodeUnsafeSupplier) {
        this._channelExternalReferenceCodeSupplier = () -> {
            try {
                return (String)channelExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getChannelId() {
        if (this._channelIdSupplier != null) {
            this.channelId = this._channelIdSupplier.get();
            this._channelIdSupplier = null;
        }
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
        this._channelIdSupplier = null;
    }

    @JsonIgnore
    public void setChannelId(UnsafeSupplier<Long, Exception> channelIdUnsafeSupplier) {
        this._channelIdSupplier = () -> {
            try {
                return (Long)channelIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30643")
    public @DecimalMin(value="0") Long getWarehouseChannelId() {
        if (this._warehouseChannelIdSupplier != null) {
            this.warehouseChannelId = this._warehouseChannelIdSupplier.get();
            this._warehouseChannelIdSupplier = null;
        }
        return this.warehouseChannelId;
    }

    public void setWarehouseChannelId(Long warehouseChannelId) {
        this.warehouseChannelId = warehouseChannelId;
        this._warehouseChannelIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseChannelId(UnsafeSupplier<Long, Exception> warehouseChannelIdUnsafeSupplier) {
        this._warehouseChannelIdSupplier = () -> {
            try {
                return (Long)warehouseChannelIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="DAB-34098-789-N")
    public String getWarehouseExternalReferenceCode() {
        if (this._warehouseExternalReferenceCodeSupplier != null) {
            this.warehouseExternalReferenceCode = this._warehouseExternalReferenceCodeSupplier.get();
            this._warehouseExternalReferenceCodeSupplier = null;
        }
        return this.warehouseExternalReferenceCode;
    }

    public void setWarehouseExternalReferenceCode(String warehouseExternalReferenceCode) {
        this.warehouseExternalReferenceCode = warehouseExternalReferenceCode;
        this._warehouseExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseExternalReferenceCode(UnsafeSupplier<String, Exception> warehouseExternalReferenceCodeUnsafeSupplier) {
        this._warehouseExternalReferenceCodeSupplier = () -> {
            try {
                return (String)warehouseExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30324")
    public @DecimalMin(value="0") Long getWarehouseId() {
        if (this._warehouseIdSupplier != null) {
            this.warehouseId = this._warehouseIdSupplier.get();
            this._warehouseIdSupplier = null;
        }
        return this.warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
        this._warehouseIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseId(UnsafeSupplier<Long, Exception> warehouseIdUnsafeSupplier) {
        this._warehouseIdSupplier = () -> {
            try {
                return (Long)warehouseIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WarehouseChannel)) {
            return false;
        }
        WarehouseChannel warehouseChannel = (WarehouseChannel)object;
        return Objects.equals(this.toString(), warehouseChannel.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long warehouseId;
        String warehouseExternalReferenceCode;
        Long warehouseChannelId;
        Long channelId;
        String channelExternalReferenceCode;
        Channel channel;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(WarehouseChannel._toJSON(actions));
        }
        if ((channel = this.getChannel()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channel\": ");
            sb.append(String.valueOf(channel));
        }
        if ((channelExternalReferenceCode = this.getChannelExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseChannel._escape(channelExternalReferenceCode));
            sb.append("\"");
        }
        if ((channelId = this.getChannelId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelId\": ");
            sb.append((Object)channelId);
        }
        if ((warehouseChannelId = this.getWarehouseChannelId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseChannelId\": ");
            sb.append((Object)warehouseChannelId);
        }
        if ((warehouseExternalReferenceCode = this.getWarehouseExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseChannel._escape(warehouseExternalReferenceCode));
            sb.append("\"");
        }
        if ((warehouseId = this.getWarehouseId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseId\": ");
            sb.append((Object)warehouseId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WarehouseChannel._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WarehouseChannel._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WarehouseChannel._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WarehouseChannel._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WarehouseChannel._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

