/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Account;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="WarehouseAccount")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"accountId", "warehouseId"})
@XmlRootElement(name="WarehouseAccount")
public class WarehouseAccount
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Account account;
    @JsonIgnore
    private Supplier<Account> _accountSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String accountExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _accountExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long accountId;
    @JsonIgnore
    private Supplier<Long> _accountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long warehouseAccountId;
    @JsonIgnore
    private Supplier<Long> _warehouseAccountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String warehouseExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _warehouseExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long warehouseId;
    @JsonIgnore
    private Supplier<Long> _warehouseIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseAccount", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static WarehouseAccount toDTO(String json) {
        return (WarehouseAccount)ObjectMapperUtil.readValue(WarehouseAccount.class, (String)json);
    }

    public static WarehouseAccount unsafeToDTO(String json) {
        return (WarehouseAccount)ObjectMapperUtil.unsafeReadValue(WarehouseAccount.class, (String)json);
    }

    @Schema
    @Valid
    public Account getAccount() {
        if (this._accountSupplier != null) {
            this.account = this._accountSupplier.get();
            this._accountSupplier = null;
        }
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
        this._accountSupplier = null;
    }

    @JsonIgnore
    public void setAccount(UnsafeSupplier<Account, Exception> accountUnsafeSupplier) {
        this._accountSupplier = () -> {
            try {
                return (Account)accountUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="DAB-34098-789-N")
    public String getAccountExternalReferenceCode() {
        if (this._accountExternalReferenceCodeSupplier != null) {
            this.accountExternalReferenceCode = this._accountExternalReferenceCodeSupplier.get();
            this._accountExternalReferenceCodeSupplier = null;
        }
        return this.accountExternalReferenceCode;
    }

    public void setAccountExternalReferenceCode(String accountExternalReferenceCode) {
        this.accountExternalReferenceCode = accountExternalReferenceCode;
        this._accountExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setAccountExternalReferenceCode(UnsafeSupplier<String, Exception> accountExternalReferenceCodeUnsafeSupplier) {
        this._accountExternalReferenceCodeSupplier = () -> {
            try {
                return (String)accountExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30324")
    public @DecimalMin(value="0") Long getAccountId() {
        if (this._accountIdSupplier != null) {
            this.accountId = this._accountIdSupplier.get();
            this._accountIdSupplier = null;
        }
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
        this._accountIdSupplier = null;
    }

    @JsonIgnore
    public void setAccountId(UnsafeSupplier<Long, Exception> accountIdUnsafeSupplier) {
        this._accountIdSupplier = () -> {
            try {
                return (Long)accountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30643")
    public @DecimalMin(value="0") Long getWarehouseAccountId() {
        if (this._warehouseAccountIdSupplier != null) {
            this.warehouseAccountId = this._warehouseAccountIdSupplier.get();
            this._warehouseAccountIdSupplier = null;
        }
        return this.warehouseAccountId;
    }

    public void setWarehouseAccountId(Long warehouseAccountId) {
        this.warehouseAccountId = warehouseAccountId;
        this._warehouseAccountIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseAccountId(UnsafeSupplier<Long, Exception> warehouseAccountIdUnsafeSupplier) {
        this._warehouseAccountIdSupplier = () -> {
            try {
                return (Long)warehouseAccountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="PAB-34098-789-N")
    public String getWarehouseExternalReferenceCode() {
        if (this._warehouseExternalReferenceCodeSupplier != null) {
            this.warehouseExternalReferenceCode = this._warehouseExternalReferenceCodeSupplier.get();
            this._warehouseExternalReferenceCodeSupplier = null;
        }
        return this.warehouseExternalReferenceCode;
    }

    public void setWarehouseExternalReferenceCode(String warehouseExternalReferenceCode) {
        this.warehouseExternalReferenceCode = warehouseExternalReferenceCode;
        this._warehouseExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseExternalReferenceCode(UnsafeSupplier<String, Exception> warehouseExternalReferenceCodeUnsafeSupplier) {
        this._warehouseExternalReferenceCodeSupplier = () -> {
            try {
                return (String)warehouseExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getWarehouseId() {
        if (this._warehouseIdSupplier != null) {
            this.warehouseId = this._warehouseIdSupplier.get();
            this._warehouseIdSupplier = null;
        }
        return this.warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
        this._warehouseIdSupplier = null;
    }

    @JsonIgnore
    public void setWarehouseId(UnsafeSupplier<Long, Exception> warehouseIdUnsafeSupplier) {
        this._warehouseIdSupplier = () -> {
            try {
                return (Long)warehouseIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WarehouseAccount)) {
            return false;
        }
        WarehouseAccount warehouseAccount = (WarehouseAccount)object;
        return Objects.equals(this.toString(), warehouseAccount.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long warehouseId;
        String warehouseExternalReferenceCode;
        Long warehouseAccountId;
        Map<String, Map<String, String>> actions;
        Long accountId;
        String accountExternalReferenceCode;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Account account = this.getAccount();
        if (account != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"account\": ");
            sb.append(String.valueOf(account));
        }
        if ((accountExternalReferenceCode = this.getAccountExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseAccount._escape(accountExternalReferenceCode));
            sb.append("\"");
        }
        if ((accountId = this.getAccountId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountId\": ");
            sb.append((Object)accountId);
        }
        if ((actions = this.getActions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(WarehouseAccount._toJSON(actions));
        }
        if ((warehouseAccountId = this.getWarehouseAccountId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseAccountId\": ");
            sb.append((Object)warehouseAccountId);
        }
        if ((warehouseExternalReferenceCode = this.getWarehouseExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(WarehouseAccount._escape(warehouseExternalReferenceCode));
            sb.append("\"");
        }
        if ((warehouseId = this.getWarehouseId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"warehouseId\": ");
            sb.append((Object)warehouseId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(WarehouseAccount._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (WarehouseAccount._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(WarehouseAccount._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WarehouseAccount._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(WarehouseAccount._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

