/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.channel.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.internal.dto.v1_0.converter.ChannelDTOConverter;
import com.liferay.headless.commerce.admin.channel.internal.odata.entity.v1_0.ChannelEntityModel;
import com.liferay.headless.commerce.admin.channel.internal.resource.v1_0.BaseChannelResourceImpl;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/channel.properties"}, scope=ServiceScope.PROTOTYPE, service={ChannelResource.class})
public class ChannelResourceImpl
extends BaseChannelResourceImpl {
    private static final EntityModel _entityModel = new ChannelEntityModel();
    @Reference
    private ChannelDTOConverter _channelDTOConverter;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteChannel(Long channelId) throws Exception {
        this._commerceChannelService.deleteCommerceChannel(channelId.longValue());
    }

    @Override
    public void deleteChannelByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceChannel == null) {
            throw new NoSuchChannelException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._commerceChannelService.deleteCommerceChannel(commerceChannel.getCommerceChannelId());
    }

    @Override
    public Channel getChannel(Long channelId) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchCommerceChannel(channelId.longValue());
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        return this._toChannel(commerceChannel);
    }

    @Override
    public Channel getChannelByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceChannel == null) {
            throw new NoSuchChannelException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toChannel(commerceChannel);
    }

    @Override
    public Page<Channel> getChannelsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceChannel.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toChannel(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Channel patchChannel(Long channelId, Channel channel) throws Exception {
        Channel existingChannel = this.getChannel(channelId);
        if (channel.getCurrencyCode() != null) {
            existingChannel.setCurrencyCode(channel.getCurrencyCode());
        }
        if (channel.getExternalReferenceCode() != null) {
            existingChannel.setExternalReferenceCode(channel.getExternalReferenceCode());
        }
        if (channel.getName() != null) {
            existingChannel.setName(channel.getName());
        }
        if (channel.getType() != null) {
            existingChannel.setType(channel.getType());
        }
        return this.putChannel(channelId, existingChannel);
    }

    @Override
    public Channel patchChannelByExternalReferenceCode(String externalReferenceCode, Channel channel) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceChannel == null) {
            throw new NoSuchChannelException("Unable to find product with external reference code " + externalReferenceCode);
        }
        Channel existingChannel = this.getChannel(commerceChannel.getCommerceChannelId());
        if (channel.getCurrencyCode() != null) {
            existingChannel.setCurrencyCode(channel.getCurrencyCode());
        }
        if (channel.getExternalReferenceCode() != null) {
            existingChannel.setExternalReferenceCode(channel.getExternalReferenceCode());
        }
        if (channel.getName() != null) {
            existingChannel.setName(channel.getName());
        }
        if (channel.getType() != null) {
            existingChannel.setType(channel.getType());
        }
        return this.putChannel(commerceChannel.getCommerceChannelId(), existingChannel);
    }

    @Override
    public Channel postChannel(Channel channel) throws Exception {
        return this._toChannel(this._commerceChannelService.addCommerceChannel(channel.getExternalReferenceCode(), (long)GetterUtil.get((Object)channel.getSiteGroupId(), (int)0), channel.getName(), channel.getType(), null, channel.getCurrencyCode(), this._serviceContextHelper.getServiceContext(this.contextUser)));
    }

    @Override
    public Channel putChannel(Long channelId, Channel channel) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchCommerceChannel(channelId.longValue());
        if (commerceChannel == null) {
            return this.postChannel(channel);
        }
        return this._toChannel(this._commerceChannelService.updateCommerceChannel(channelId.longValue(), channel.getSiteGroupId().longValue(), channel.getName(), channel.getType(), null, channel.getCurrencyCode()));
    }

    @Override
    public Channel putChannelByExternalReferenceCode(String externalReferenceCode, Channel channel) throws Exception {
        return this._toChannel(this._commerceChannelService.addOrUpdateCommerceChannel(externalReferenceCode, channel.getSiteGroupId().longValue(), channel.getName(), channel.getType(), null, channel.getCurrencyCode(), this._serviceContextHelper.getServiceContext()));
    }

    private Channel _toChannel(CommerceChannel commerceChannel) throws Exception {
        return this._toChannel(commerceChannel.getCommerceChannelId());
    }

    private Channel _toChannel(Long commerceChannelId) throws Exception {
        return this._channelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceChannelId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

