/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionCategoryDTOConverter;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPSpecificationOption"}, service={DTOConverter.class, SpecificationDTOConverter.class})
public class SpecificationDTOConverter
implements DTOConverter<CPSpecificationOption, Specification> {
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private OptionCategoryDTOConverter _optionCategoryDTOConverter;

    public String getContentType() {
        return Specification.class.getSimpleName();
    }

    public Specification toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(((Long)dtoConverterContext.getId()).longValue());
        CPOptionCategory cpOptionCategory = cpSpecificationOption.getCPOptionCategory();
        Specification specification = new Specification(){
            {
                this.description = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getDescriptionMap());
                this.facetable = cpSpecificationOption.isFacetable();
                this.id = cpSpecificationOption.getCPSpecificationOptionId();
                this.key = cpSpecificationOption.getKey();
                this.title = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getTitleMap());
            }
        };
        if (cpOptionCategory != null) {
            specification.setOptionCategory(this._optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpOptionCategory.getCPOptionCategoryId(), dtoConverterContext.getLocale())));
        }
        return specification;
    }
}

