/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ProductSpecification")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"specificationKey", "value"})
@XmlRootElement(name="ProductSpecification")
public class ProductSpecification
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> label;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long optionCategoryId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double priority;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long productId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long specificationId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String specificationKey;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Map<String, String> value;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};

    public static ProductSpecification toDTO(String json) {
        return (ProductSpecification)ObjectMapperUtil.readValue(ProductSpecification.class, (String)json);
    }

    public static ProductSpecification unsafeToDTO(String json) {
        return (ProductSpecification)ObjectMapperUtil.unsafeReadValue(ProductSpecification.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="31130")
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="{en_US=Hand Saw, hr_HR=Product Name HR, hu_HU=Product Name HU}")
    @Valid
    public Map<String, String> getLabel() {
        return this.label;
    }

    public void setLabel(Map<String, String> label) {
        this.label = label;
    }

    @JsonIgnore
    public void setLabel(UnsafeSupplier<Map<String, String>, Exception> labelUnsafeSupplier) {
        try {
            this.label = (Map)labelUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30129")
    public @DecimalMin(value="0") Long getOptionCategoryId() {
        return this.optionCategoryId;
    }

    public void setOptionCategoryId(Long optionCategoryId) {
        this.optionCategoryId = optionCategoryId;
    }

    @JsonIgnore
    public void setOptionCategoryId(UnsafeSupplier<Long, Exception> optionCategoryIdUnsafeSupplier) {
        try {
            this.optionCategoryId = (Long)optionCategoryIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="1.2")
    public @DecimalMin(value="0") Double getPriority() {
        return this.priority;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    @JsonIgnore
    public void setPriority(UnsafeSupplier<Double, Exception> priorityUnsafeSupplier) {
        try {
            this.priority = (Double)priorityUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30129")
    public @DecimalMin(value="0") Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    @JsonIgnore
    public void setProductId(UnsafeSupplier<Long, Exception> productIdUnsafeSupplier) {
        try {
            this.productId = (Long)productIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(example="30129")
    public @DecimalMin(value="0") Long getSpecificationId() {
        return this.specificationId;
    }

    public void setSpecificationId(Long specificationId) {
        this.specificationId = specificationId;
    }

    @JsonIgnore
    public void setSpecificationId(UnsafeSupplier<Long, Exception> specificationIdUnsafeSupplier) {
        try {
            this.specificationId = (Long)specificationIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="specification-key")
    public String getSpecificationKey() {
        return this.specificationKey;
    }

    public void setSpecificationKey(String specificationKey) {
        this.specificationKey = specificationKey;
    }

    @JsonIgnore
    public void setSpecificationKey(UnsafeSupplier<String, Exception> specificationKeyUnsafeSupplier) {
        try {
            this.specificationKey = (String)specificationKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="{en_US=Croatia, hr_HR=Hrvatska, hu_HU=Horvatorszag}")
    @Valid
    public Map<String, String> getValue() {
        return this.value;
    }

    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    @JsonIgnore
    public void setValue(UnsafeSupplier<Map<String, String>, Exception> valueUnsafeSupplier) {
        try {
            this.value = (Map)valueUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductSpecification)) {
            return false;
        }
        ProductSpecification productSpecification = (ProductSpecification)object;
        return Objects.equals(this.toString(), productSpecification.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.label != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"label\": ");
            sb.append(ProductSpecification._toJSON(this.label));
        }
        if (this.optionCategoryId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"optionCategoryId\": ");
            sb.append((Object)this.optionCategoryId);
        }
        if (this.priority != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append((Object)this.priority);
        }
        if (this.productId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productId\": ");
            sb.append((Object)this.productId);
        }
        if (this.specificationId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"specificationId\": ");
            sb.append((Object)this.specificationId);
        }
        if (this.specificationKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"specificationKey\": ");
            sb.append("\"");
            sb.append(ProductSpecification._escape(this.specificationKey));
            sb.append("\"");
        }
        if (this.value != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"value\": ");
            sb.append(ProductSpecification._toJSON(this.value));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ProductSpecification._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ProductSpecification._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ProductSpecification._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ProductSpecification._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

