/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="AccountOrganization")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="AccountOrganization")
public class AccountOrganization
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long accountId;
    @JsonIgnore
    private Supplier<Long> _accountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String organizationExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _organizationExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long organizationId;
    @JsonIgnore
    private Supplier<Long> _organizationIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String treePath;
    @JsonIgnore
    private Supplier<String> _treePathSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static AccountOrganization toDTO(String json) {
        return (AccountOrganization)ObjectMapperUtil.readValue(AccountOrganization.class, (String)json);
    }

    public static AccountOrganization unsafeToDTO(String json) {
        return (AccountOrganization)ObjectMapperUtil.unsafeReadValue(AccountOrganization.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getAccountId() {
        if (this._accountIdSupplier != null) {
            this.accountId = this._accountIdSupplier.get();
            this._accountIdSupplier = null;
        }
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
        this._accountIdSupplier = null;
    }

    @JsonIgnore
    public void setAccountId(UnsafeSupplier<Long, Exception> accountIdUnsafeSupplier) {
        this._accountIdSupplier = () -> {
            try {
                return (Long)accountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Organization Name")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="UAB-34098-789-N")
    public String getOrganizationExternalReferenceCode() {
        if (this._organizationExternalReferenceCodeSupplier != null) {
            this.organizationExternalReferenceCode = this._organizationExternalReferenceCodeSupplier.get();
            this._organizationExternalReferenceCodeSupplier = null;
        }
        return this.organizationExternalReferenceCode;
    }

    public void setOrganizationExternalReferenceCode(String organizationExternalReferenceCode) {
        this.organizationExternalReferenceCode = organizationExternalReferenceCode;
        this._organizationExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setOrganizationExternalReferenceCode(UnsafeSupplier<String, Exception> organizationExternalReferenceCodeUnsafeSupplier) {
        this._organizationExternalReferenceCodeSupplier = () -> {
            try {
                return (String)organizationExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30002")
    public @DecimalMin(value="0") Long getOrganizationId() {
        if (this._organizationIdSupplier != null) {
            this.organizationId = this._organizationIdSupplier.get();
            this._organizationIdSupplier = null;
        }
        return this.organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
        this._organizationIdSupplier = null;
    }

    @JsonIgnore
    public void setOrganizationId(UnsafeSupplier<Long, Exception> organizationIdUnsafeSupplier) {
        this._organizationIdSupplier = () -> {
            try {
                return (Long)organizationIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="/Parent Organization/Organization Name")
    public String getTreePath() {
        if (this._treePathSupplier != null) {
            this.treePath = this._treePathSupplier.get();
            this._treePathSupplier = null;
        }
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath;
        this._treePathSupplier = null;
    }

    @JsonIgnore
    public void setTreePath(UnsafeSupplier<String, Exception> treePathUnsafeSupplier) {
        this._treePathSupplier = () -> {
            try {
                return (String)treePathUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccountOrganization)) {
            return false;
        }
        AccountOrganization accountOrganization = (AccountOrganization)object;
        return Objects.equals(this.toString(), accountOrganization.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String treePath;
        Long organizationId;
        String organizationExternalReferenceCode;
        String name;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Long accountId = this.getAccountId();
        if (accountId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountId\": ");
            sb.append((Object)accountId);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(AccountOrganization._escape(name));
            sb.append("\"");
        }
        if ((organizationExternalReferenceCode = this.getOrganizationExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(AccountOrganization._escape(organizationExternalReferenceCode));
            sb.append("\"");
        }
        if ((organizationId = this.getOrganizationId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationId\": ");
            sb.append((Object)organizationId);
        }
        if ((treePath = this.getTreePath()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"treePath\": ");
            sb.append("\"");
            sb.append(AccountOrganization._escape(treePath));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(AccountOrganization._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (AccountOrganization._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(AccountOrganization._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(AccountOrganization._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AccountOrganization._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

