/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountRole;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="AccountMember")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"email"})
@XmlRootElement(name="AccountMember")
public class AccountMember
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long accountId;
    @JsonIgnore
    private Supplier<Long> _accountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountRole[] accountRoles;
    @JsonIgnore
    private Supplier<AccountRole[]> _accountRolesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String email;
    @JsonIgnore
    private Supplier<String> _emailSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String userExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _userExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long userId;
    @JsonIgnore
    private Supplier<Long> _userIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static AccountMember toDTO(String json) {
        return (AccountMember)ObjectMapperUtil.readValue(AccountMember.class, (String)json);
    }

    public static AccountMember unsafeToDTO(String json) {
        return (AccountMember)ObjectMapperUtil.unsafeReadValue(AccountMember.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getAccountId() {
        if (this._accountIdSupplier != null) {
            this.accountId = this._accountIdSupplier.get();
            this._accountIdSupplier = null;
        }
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
        this._accountIdSupplier = null;
    }

    @JsonIgnore
    public void setAccountId(UnsafeSupplier<Long, Exception> accountIdUnsafeSupplier) {
        this._accountIdSupplier = () -> {
            try {
                return (Long)accountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[{description={en_US=Account Administrator Description US, hr_HR=Account Administrator Description HR, hu_HU=Account Administrator Description HU}}, {description={en_US=Order Manager Description US, hr_HR=Order Manager Description HR, hu_HU=Order Manager Description HU}}]")
    @Valid
    public AccountRole[] getAccountRoles() {
        if (this._accountRolesSupplier != null) {
            this.accountRoles = this._accountRolesSupplier.get();
            this._accountRolesSupplier = null;
        }
        return this.accountRoles;
    }

    public void setAccountRoles(AccountRole[] accountRoles) {
        this.accountRoles = accountRoles;
        this._accountRolesSupplier = null;
    }

    @JsonIgnore
    public void setAccountRoles(UnsafeSupplier<AccountRole[], Exception> accountRolesUnsafeSupplier) {
        this._accountRolesSupplier = () -> {
            try {
                return (AccountRole[])accountRolesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="joe.1@commerce.com")
    public String getEmail() {
        if (this._emailSupplier != null) {
            this.email = this._emailSupplier.get();
            this._emailSupplier = null;
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this._emailSupplier = null;
    }

    @JsonIgnore
    public void setEmail(UnsafeSupplier<String, Exception> emailUnsafeSupplier) {
        this._emailSupplier = () -> {
            try {
                return (String)emailUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="User Name")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="UAB-34098-789-N")
    public String getUserExternalReferenceCode() {
        if (this._userExternalReferenceCodeSupplier != null) {
            this.userExternalReferenceCode = this._userExternalReferenceCodeSupplier.get();
            this._userExternalReferenceCodeSupplier = null;
        }
        return this.userExternalReferenceCode;
    }

    public void setUserExternalReferenceCode(String userExternalReferenceCode) {
        this.userExternalReferenceCode = userExternalReferenceCode;
        this._userExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setUserExternalReferenceCode(UnsafeSupplier<String, Exception> userExternalReferenceCodeUnsafeSupplier) {
        this._userExternalReferenceCodeSupplier = () -> {
            try {
                return (String)userExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30002")
    public @DecimalMin(value="0") Long getUserId() {
        if (this._userIdSupplier != null) {
            this.userId = this._userIdSupplier.get();
            this._userIdSupplier = null;
        }
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
        this._userIdSupplier = null;
    }

    @JsonIgnore
    public void setUserId(UnsafeSupplier<Long, Exception> userIdUnsafeSupplier) {
        this._userIdSupplier = () -> {
            try {
                return (Long)userIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccountMember)) {
            return false;
        }
        AccountMember accountMember = (AccountMember)object;
        return Objects.equals(this.toString(), accountMember.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long userId;
        String userExternalReferenceCode;
        String name;
        String externalReferenceCode;
        String email;
        AccountRole[] accountRoles;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Long accountId = this.getAccountId();
        if (accountId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountId\": ");
            sb.append((Object)accountId);
        }
        if ((accountRoles = this.getAccountRoles()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountRoles\": ");
            sb.append("[");
            for (int i = 0; i < accountRoles.length; ++i) {
                sb.append(String.valueOf(accountRoles[i]));
                if (i + 1 >= accountRoles.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((email = this.getEmail()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"email\": ");
            sb.append("\"");
            sb.append(AccountMember._escape(email));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(AccountMember._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(AccountMember._escape(name));
            sb.append("\"");
        }
        if ((userExternalReferenceCode = this.getUserExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(AccountMember._escape(userExternalReferenceCode));
            sb.append("\"");
        }
        if ((userId = this.getUserId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userId\": ");
            sb.append((Object)userId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(AccountMember._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (AccountMember._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(AccountMember._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(AccountMember._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AccountMember._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

