/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Account")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"externalReferenceCode", "name"})
@XmlRootElement(name="Account")
public class Account
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountAddress[] accountAddresses;
    @JsonIgnore
    private Supplier<AccountAddress[]> _accountAddressesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountMember[] accountMembers;
    @JsonIgnore
    private Supplier<AccountMember[]> _accountMembersSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountOrganization[] accountOrganizations;
    @JsonIgnore
    private Supplier<AccountOrganization[]> _accountOrganizationsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean active;
    @JsonIgnore
    private Supplier<Boolean> _activeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, ?> customFields;
    @JsonIgnore
    private Supplier<Map<String, ?>> _customFieldsSupplier;
    @GraphQLField(description="The account's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The account's most recent modification date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's most recent modification date.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultBillingAccountAddressId;
    @JsonIgnore
    private Supplier<Long> _defaultBillingAccountAddressIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultShippingAccountAddressId;
    @JsonIgnore
    private Supplier<Long> _defaultShippingAccountAddressIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] emailAddresses;
    @JsonIgnore
    private Supplier<String[]> _emailAddressesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long logoId;
    @JsonIgnore
    private Supplier<Long> _logoIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String logoURL;
    @JsonIgnore
    private Supplier<String> _logoURLSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean root;
    @JsonIgnore
    private Supplier<Boolean> _rootSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String taxId;
    @JsonIgnore
    private Supplier<String> _taxIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer type;
    @JsonIgnore
    private Supplier<Integer> _typeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.account.dto.v1_0.Account", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Account toDTO(String json) {
        return (Account)ObjectMapperUtil.readValue(Account.class, (String)json);
    }

    public static Account unsafeToDTO(String json) {
        return (Account)ObjectMapperUtil.unsafeReadValue(Account.class, (String)json);
    }

    @Schema(example="[{city=Diamond Bar, countryISOCode=US, defaultBilling=true, defaultShipping=true, description=right stairs, first room on the left, id=31130, latitude=33.9976884, longitude=-117.8144595, name=Alessio Antonio Rendina, phoneNumber=(123) 456 7890, regionISOCode=CA, street1=1400 Montefino Ave, street2=1st floor, street3=suite 200, zip=91765}]")
    @Valid
    public AccountAddress[] getAccountAddresses() {
        if (this._accountAddressesSupplier != null) {
            this.accountAddresses = this._accountAddressesSupplier.get();
            this._accountAddressesSupplier = null;
        }
        return this.accountAddresses;
    }

    public void setAccountAddresses(AccountAddress[] accountAddresses) {
        this.accountAddresses = accountAddresses;
        this._accountAddressesSupplier = null;
    }

    @JsonIgnore
    public void setAccountAddresses(UnsafeSupplier<AccountAddress[], Exception> accountAddressesUnsafeSupplier) {
        this._accountAddressesSupplier = () -> {
            try {
                return (AccountAddress[])accountAddressesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[{description={en_US=Account Administrator Description US, hr_HR=Account Administrator Description HR, hu_HU=Account Administrator Description HU}}, {id=31256, name=Alessio Antonio Rendina, roles=null}]")
    @Valid
    public AccountMember[] getAccountMembers() {
        if (this._accountMembersSupplier != null) {
            this.accountMembers = this._accountMembersSupplier.get();
            this._accountMembersSupplier = null;
        }
        return this.accountMembers;
    }

    public void setAccountMembers(AccountMember[] accountMembers) {
        this.accountMembers = accountMembers;
        this._accountMembersSupplier = null;
    }

    @JsonIgnore
    public void setAccountMembers(UnsafeSupplier<AccountMember[], Exception> accountMembersUnsafeSupplier) {
        this._accountMembersSupplier = () -> {
            try {
                return (AccountMember[])accountMembersUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[{id=20546, name=Liferay Italy, organizationId=20433, treePath=/Liferay/Liferay Italy}]")
    @Valid
    public AccountOrganization[] getAccountOrganizations() {
        if (this._accountOrganizationsSupplier != null) {
            this.accountOrganizations = this._accountOrganizationsSupplier.get();
            this._accountOrganizationsSupplier = null;
        }
        return this.accountOrganizations;
    }

    public void setAccountOrganizations(AccountOrganization[] accountOrganizations) {
        this.accountOrganizations = accountOrganizations;
        this._accountOrganizationsSupplier = null;
    }

    @JsonIgnore
    public void setAccountOrganizations(UnsafeSupplier<AccountOrganization[], Exception> accountOrganizationsUnsafeSupplier) {
        this._accountOrganizationsSupplier = () -> {
            try {
                return (AccountOrganization[])accountOrganizationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getActive() {
        if (this._activeSupplier != null) {
            this.active = this._activeSupplier.get();
            this._activeSupplier = null;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
        this._activeSupplier = null;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        this._activeSupplier = () -> {
            try {
                return (Boolean)activeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, ?> getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(Map<String, ?> customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<Map<String, ?>, Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (Map)customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The account's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The account's most recent modification date.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="10130")
    public @DecimalMin(value="0") Long getDefaultBillingAccountAddressId() {
        if (this._defaultBillingAccountAddressIdSupplier != null) {
            this.defaultBillingAccountAddressId = this._defaultBillingAccountAddressIdSupplier.get();
            this._defaultBillingAccountAddressIdSupplier = null;
        }
        return this.defaultBillingAccountAddressId;
    }

    public void setDefaultBillingAccountAddressId(Long defaultBillingAccountAddressId) {
        this.defaultBillingAccountAddressId = defaultBillingAccountAddressId;
        this._defaultBillingAccountAddressIdSupplier = null;
    }

    @JsonIgnore
    public void setDefaultBillingAccountAddressId(UnsafeSupplier<Long, Exception> defaultBillingAccountAddressIdUnsafeSupplier) {
        this._defaultBillingAccountAddressIdSupplier = () -> {
            try {
                return (Long)defaultBillingAccountAddressIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="10131")
    public @DecimalMin(value="0") Long getDefaultShippingAccountAddressId() {
        if (this._defaultShippingAccountAddressIdSupplier != null) {
            this.defaultShippingAccountAddressId = this._defaultShippingAccountAddressIdSupplier.get();
            this._defaultShippingAccountAddressIdSupplier = null;
        }
        return this.defaultShippingAccountAddressId;
    }

    public void setDefaultShippingAccountAddressId(Long defaultShippingAccountAddressId) {
        this.defaultShippingAccountAddressId = defaultShippingAccountAddressId;
        this._defaultShippingAccountAddressIdSupplier = null;
    }

    @JsonIgnore
    public void setDefaultShippingAccountAddressId(UnsafeSupplier<Long, Exception> defaultShippingAccountAddressIdUnsafeSupplier) {
        this._defaultShippingAccountAddressIdSupplier = () -> {
            try {
                return (Long)defaultShippingAccountAddressIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[joe.1@commerce.com, joe.2@commerce.com, joe.3@commerce.com]")
    public String[] getEmailAddresses() {
        if (this._emailAddressesSupplier != null) {
            this.emailAddresses = this._emailAddressesSupplier.get();
            this._emailAddressesSupplier = null;
        }
        return this.emailAddresses;
    }

    public void setEmailAddresses(String[] emailAddresses) {
        this.emailAddresses = emailAddresses;
        this._emailAddressesSupplier = null;
    }

    @JsonIgnore
    public void setEmailAddresses(UnsafeSupplier<String[], Exception> emailAddressesUnsafeSupplier) {
        this._emailAddressesSupplier = () -> {
            try {
                return (String[])emailAddressesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="20078")
    public @DecimalMin(value="0") Long getLogoId() {
        if (this._logoIdSupplier != null) {
            this.logoId = this._logoIdSupplier.get();
            this._logoIdSupplier = null;
        }
        return this.logoId;
    }

    public void setLogoId(Long logoId) {
        this.logoId = logoId;
        this._logoIdSupplier = null;
    }

    @JsonIgnore
    public void setLogoId(UnsafeSupplier<Long, Exception> logoIdUnsafeSupplier) {
        this._logoIdSupplier = () -> {
            try {
                return (Long)logoIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getLogoURL() {
        if (this._logoURLSupplier != null) {
            this.logoURL = this._logoURLSupplier.get();
            this._logoURLSupplier = null;
        }
        return this.logoURL;
    }

    public void setLogoURL(String logoURL) {
        this.logoURL = logoURL;
        this._logoURLSupplier = null;
    }

    @JsonIgnore
    public void setLogoURL(UnsafeSupplier<String, Exception> logoURLUnsafeSupplier) {
        this._logoURLSupplier = () -> {
            try {
                return (String)logoURLUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Account Name")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getRoot() {
        if (this._rootSupplier != null) {
            this.root = this._rootSupplier.get();
            this._rootSupplier = null;
        }
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
        this._rootSupplier = null;
    }

    @JsonIgnore
    public void setRoot(UnsafeSupplier<Boolean, Exception> rootUnsafeSupplier) {
        this._rootSupplier = () -> {
            try {
                return (Boolean)rootUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Abcd1234")
    public String getTaxId() {
        if (this._taxIdSupplier != null) {
            this.taxId = this._taxIdSupplier.get();
            this._taxIdSupplier = null;
        }
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
        this._taxIdSupplier = null;
    }

    @JsonIgnore
    public void setTaxId(UnsafeSupplier<String, Exception> taxIdUnsafeSupplier) {
        this._taxIdSupplier = () -> {
            try {
                return (String)taxIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMax(value="2")
    @DecimalMin(value="0")
    @Schema(example="1")
    public @DecimalMax(value="2") @DecimalMin(value="0") Integer getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Integer, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Integer)typeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return Objects.equals(this.toString(), account.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Integer type;
        String taxId;
        Boolean root;
        String name;
        String logoURL;
        Long logoId;
        Long id;
        String externalReferenceCode;
        String[] emailAddresses;
        Long defaultShippingAccountAddressId;
        Long defaultBillingAccountAddressId;
        Date dateModified;
        Date dateCreated;
        Map<String, ?> customFields;
        Boolean active;
        AccountOrganization[] accountOrganizations;
        AccountMember[] accountMembers;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        AccountAddress[] accountAddresses = this.getAccountAddresses();
        if (accountAddresses != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountAddresses\": ");
            sb.append("[");
            for (int i = 0; i < accountAddresses.length; ++i) {
                sb.append(String.valueOf(accountAddresses[i]));
                if (i + 1 >= accountAddresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((accountMembers = this.getAccountMembers()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountMembers\": ");
            sb.append("[");
            for (int i = 0; i < accountMembers.length; ++i) {
                sb.append(String.valueOf(accountMembers[i]));
                if (i + 1 >= accountMembers.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((accountOrganizations = this.getAccountOrganizations()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountOrganizations\": ");
            sb.append("[");
            for (int i = 0; i < accountOrganizations.length; ++i) {
                sb.append(String.valueOf(accountOrganizations[i]));
                if (i + 1 >= accountOrganizations.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((active = this.getActive()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)active);
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append(Account._toJSON(customFields));
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((defaultBillingAccountAddressId = this.getDefaultBillingAccountAddressId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultBillingAccountAddressId\": ");
            sb.append((Object)defaultBillingAccountAddressId);
        }
        if ((defaultShippingAccountAddressId = this.getDefaultShippingAccountAddressId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultShippingAccountAddressId\": ");
            sb.append((Object)defaultShippingAccountAddressId);
        }
        if ((emailAddresses = this.getEmailAddresses()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emailAddresses\": ");
            sb.append("[");
            for (int i = 0; i < emailAddresses.length; ++i) {
                sb.append("\"");
                sb.append(Account._escape(emailAddresses[i]));
                sb.append("\"");
                if (i + 1 >= emailAddresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Account._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((logoId = this.getLogoId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoId\": ");
            sb.append((Object)logoId);
        }
        if ((logoURL = this.getLogoURL()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoURL\": ");
            sb.append("\"");
            sb.append(Account._escape(logoURL));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Account._escape(name));
            sb.append("\"");
        }
        if ((root = this.getRoot()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"root\": ");
            sb.append((Object)root);
        }
        if ((taxId = this.getTaxId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxId\": ");
            sb.append("\"");
            sb.append(Account._escape(taxId));
            sb.append("\"");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append((Object)type);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Account._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Account._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Account._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Account._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Account._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

