/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Error")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"errorCode", "errorDescription", "message", "status"})
@XmlRootElement(name="Error")
public class Error {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotNull
    protected Integer errorCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotEmpty
    protected String errorDescription;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotEmpty
    protected String message;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotNull
    protected Integer status;

    @Schema(description="Internal error code mapping", example="996")
    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    @JsonIgnore
    public void setErrorCode(UnsafeSupplier<Integer, Exception> errorCodeUnsafeSupplier) {
        try {
            this.errorCode = (Integer)errorCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="Unable to find currency. Currency code should be expressed with 3-letter ISO 4217 format.")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    @JsonIgnore
    public void setErrorDescription(UnsafeSupplier<String, Exception> errorDescriptionUnsafeSupplier) {
        try {
            this.errorDescription = (String)errorDescriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="No CommerceCurrency exists with the key {groupId=41811, code=US Dollar}")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public void setMessage(UnsafeSupplier<String, Exception> messageUnsafeSupplier) {
        try {
            this.message = (String)messageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="HTTP Status code", example="404")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        try {
            this.status = (Integer)statusUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Error)) {
            return false;
        }
        Error error = (Error)object;
        return Objects.equals(this.toString(), error.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.errorCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorCode\": ");
            sb.append((Object)this.errorCode);
        }
        if (this.errorDescription != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorDescription\": ");
            sb.append("\"");
            sb.append(Error._escape(this.errorDescription));
            sb.append("\"");
        }
        if (this.message != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"message\": ");
            sb.append("\"");
            sb.append(Error._escape(this.message));
            sb.append("\"");
        }
        if (this.status != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

