/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Address;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Account")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"externalReferenceCode", "name"})
@XmlRootElement(name="Account")
public class Account {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Address[] addresses;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] emailAddresses;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long logoId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountOrganization[] organizations;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean root;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String taxId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer type;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountMember[] users;

    @Schema
    public Address[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Address[] addresses) {
        this.addresses = addresses;
    }

    @JsonIgnore
    public void setAddresses(UnsafeSupplier<Address[], Exception> addressesUnsafeSupplier) {
        try {
            this.addresses = (Address[])addressesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String[] getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String[] emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @JsonIgnore
    public void setEmailAddresses(UnsafeSupplier<String[], Exception> emailAddressesUnsafeSupplier) {
        try {
            this.emailAddresses = (String[])emailAddressesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="30130")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="20078")
    public Long getLogoId() {
        return this.logoId;
    }

    public void setLogoId(Long logoId) {
        this.logoId = logoId;
    }

    @JsonIgnore
    public void setLogoId(UnsafeSupplier<Long, Exception> logoIdUnsafeSupplier) {
        try {
            this.logoId = (Long)logoIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="Account Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public AccountOrganization[] getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(AccountOrganization[] organizations) {
        this.organizations = organizations;
    }

    @JsonIgnore
    public void setOrganizations(UnsafeSupplier<AccountOrganization[], Exception> organizationsUnsafeSupplier) {
        try {
            this.organizations = (AccountOrganization[])organizationsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="true")
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    @JsonIgnore
    public void setRoot(UnsafeSupplier<Boolean, Exception> rootUnsafeSupplier) {
        try {
            this.root = (Boolean)rootUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="Abcd1234")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonIgnore
    public void setTaxId(UnsafeSupplier<String, Exception> taxIdUnsafeSupplier) {
        try {
            this.taxId = (String)taxIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(example="1")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Integer, Exception> typeUnsafeSupplier) {
        try {
            this.type = (Integer)typeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public AccountMember[] getUsers() {
        return this.users;
    }

    public void setUsers(AccountMember[] users) {
        this.users = users;
    }

    @JsonIgnore
    public void setUsers(UnsafeSupplier<AccountMember[], Exception> usersUnsafeSupplier) {
        try {
            this.users = (AccountMember[])usersUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return Objects.equals(this.toString(), account.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.addresses != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"addresses\": ");
            sb.append("[");
            for (i = 0; i < this.addresses.length; ++i) {
                sb.append(String.valueOf(this.addresses[i]));
                if (i + 1 >= this.addresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.emailAddresses != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emailAddresses\": ");
            sb.append("[");
            for (i = 0; i < this.emailAddresses.length; ++i) {
                sb.append("\"");
                sb.append(Account._escape(this.emailAddresses[i]));
                sb.append("\"");
                if (i + 1 >= this.emailAddresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Account._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.logoId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoId\": ");
            sb.append((Object)this.logoId);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Account._escape(this.name));
            sb.append("\"");
        }
        if (this.organizations != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizations\": ");
            sb.append("[");
            for (i = 0; i < this.organizations.length; ++i) {
                sb.append(String.valueOf(this.organizations[i]));
                if (i + 1 >= this.organizations.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.root != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"root\": ");
            sb.append((Object)this.root);
        }
        if (this.taxId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxId\": ");
            sb.append("\"");
            sb.append(Account._escape(this.taxId));
            sb.append("\"");
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append((Object)this.type);
        }
        if (this.users != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"users\": ");
            sb.append("[");
            for (i = 0; i < this.users.length; ++i) {
                sb.append(String.valueOf(this.users[i]));
                if (i + 1 >= this.users.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

