/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.minium.internal.helper;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceThemeMiniumHttpHelper.class})
public class CommerceThemeMiniumHttpHelper {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private Language _language;
    @Reference
    private PanelAppRegistry _panelAppRegistry;
    @Reference
    private Portal _portal;

    public String getAccountManagementPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._commerceAccountHelper.getAccountManagementPortletURL(httpServletRequest);
    }

    public String getMyListsLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "my-lists");
    }

    public int getNotificationsCount(ThemeDisplay themeDisplay) {
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry);
        return panelCategoryHelper.getNotificationsCount("user.my_account", themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup(), themeDisplay.getUser());
    }

    public String getNotificationsURL(HttpServletRequest httpServletRequest) throws PortalException {
        return String.valueOf(PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)UserNotificationEvent.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW));
    }

    public String getRedirectURL(HttpServletRequest httpServletRequest) throws PortalException {
        Object value = httpServletRequest.getAttribute(NoSuchLayoutException.class.getName());
        if (value != null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletURL = this._getPortletURL("/dashboard", httpServletRequest, themeDisplay, "com_liferay_commerce_dashboard_web_internal_portlet_CommerceDashboardForecastsChartPortlet");
        if (Validator.isBlank((String)portletURL)) {
            portletURL = this._getPortletURL("/catalog", httpServletRequest, themeDisplay, "com_liferay_commerce_product_content_search_web_internal_portlet_CPSearchResultsPortlet");
        }
        List layouts = themeDisplay.getLayouts();
        if (Validator.isBlank((String)portletURL) && ListUtil.isNotEmpty((List)layouts)) {
            return this._portal.getLayoutURL((Layout)layouts.get(0), themeDisplay);
        }
        if (!Validator.isBlank((String)portletURL) && portletURL.contains("?")) {
            portletURL = portletURL.substring(0, portletURL.lastIndexOf("?"));
        }
        if (!Validator.isBlank((String)portletURL) && Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
            portletURL = this._portal.addPreservedParameters(themeDisplay, portletURL, false, true);
        }
        return portletURL;
    }

    private String _getPortletURL(String friendlyURL, HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, String portletId) throws PortalException {
        List layouts = themeDisplay.getLayouts();
        if (ListUtil.isEmpty((List)layouts)) {
            return "";
        }
        for (Layout layout : layouts) {
            if (!Objects.equals(friendlyURL, layout.getFriendlyURL())) continue;
            return this._portal.getLayoutURL(layout, themeDisplay);
        }
        long plid = this._portal.getPlidFromPortletId(themeDisplay.getScopeGroupId(), portletId);
        if (plid == 0L) {
            return "";
        }
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)portletId, (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (portletURL == null) {
            return "";
        }
        return String.valueOf(portletURL);
    }
}

