/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.test.util;

import com.liferay.commerce.account.exception.CommerceAccountTypeException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalServiceUtil;
import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.test.util.CommerceCurrencyTestUtil;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalServiceUtil;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CPInstanceLocalServiceUtil;
import com.liferay.commerce.product.service.CommerceCatalogLocalServiceUtil;
import com.liferay.commerce.product.service.CommerceChannelLocalServiceUtil;
import com.liferay.commerce.product.service.CommerceChannelRelLocalServiceUtil;
import com.liferay.commerce.product.test.util.CPTestUtil;
import com.liferay.commerce.service.CPDefinitionInventoryLocalServiceUtil;
import com.liferay.commerce.service.CommerceAddressLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderItemLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderLocalServiceUtil;
import com.liferay.commerce.service.CommerceShippingMethodLocalServiceUtil;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalServiceUtil;
import com.liferay.commerce.test.util.CommerceInventoryTestUtil;
import com.liferay.commerce.test.util.context.TestCommerceContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class CommerceTestUtil {
    public static CommerceAccount addAccount(long groupId, long userId) throws Exception {
        return CommerceAccountLocalServiceUtil.addPersonalCommerceAccount((long)userId, (String)"", (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CommerceOrder addB2BCommerceOrder(long groupId, long userId, long commerceAccountId, long commerceCurrencyId) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        if (userId == 0L) {
            userId = serviceContext.getUserId();
        }
        long commerceChannelGroupId = CommerceChannelLocalServiceUtil.getCommerceChannelGroupIdBySiteGroupId((long)groupId);
        return CommerceOrderLocalServiceUtil.addCommerceOrder((long)userId, (long)commerceChannelGroupId, (long)commerceAccountId, (long)commerceCurrencyId);
    }

    public static CommerceOrder addB2CCommerceOrder(long userId, long groupId, CommerceCurrency commerceCurrency) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        if (userId == 0L) {
            userId = serviceContext.getUserId();
        }
        CommerceAccount commerceAccount = CommerceAccountLocalServiceUtil.getPersonalCommerceAccount((long)userId);
        return CommerceOrderLocalServiceUtil.addCommerceOrder((long)userId, (long)groupId, (long)commerceAccount.getCommerceAccountId(), (long)commerceCurrency.getCommerceCurrencyId());
    }

    public static CommerceOrder addB2CCommerceOrder(long userId, long groupId, long commerceCurrencyId) throws Exception {
        CommerceAccount commerceAccount;
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        if (userId == 0L) {
            userId = serviceContext.getUserId();
        }
        try {
            commerceAccount = CommerceAccountLocalServiceUtil.addPersonalCommerceAccount((long)userId, (String)"", (String)"", (ServiceContext)serviceContext);
        }
        catch (CommerceAccountTypeException commerceAccountTypeException) {
            commerceAccount = CommerceAccountLocalServiceUtil.getPersonalCommerceAccount((long)userId);
        }
        return CommerceOrderLocalServiceUtil.addCommerceOrder((long)userId, (long)groupId, (long)commerceAccount.getCommerceAccountId(), (long)commerceCurrencyId);
    }

    public static CommerceOrder addCheckoutDetailsToCommerceOrder(CommerceOrder commerceOrder, long userId, boolean paymentSubscription) throws Exception {
        return CommerceTestUtil.addCheckoutDetailsToCommerceOrder(commerceOrder, userId, paymentSubscription, false, RandomTestUtil.randomDouble());
    }

    public static CommerceOrder addCheckoutDetailsToCommerceOrder(CommerceOrder commerceOrder, long userId, boolean paymentSubscription, boolean deliverySubscription) throws Exception {
        return CommerceTestUtil.addCheckoutDetailsToCommerceOrder(commerceOrder, userId, paymentSubscription, deliverySubscription, RandomTestUtil.randomDouble());
    }

    public static CommerceOrder addCheckoutDetailsToCommerceOrder(CommerceOrder commerceOrder, long userId, boolean paymentSubscription, boolean deliverySubscription, double cpInstancePrice) throws Exception {
        long groupId = commerceOrder.getGroupId();
        CPInstance cpInstance = CPTestUtil.addCPInstanceWithRandomSku((long)groupId);
        cpInstance.setPrice(BigDecimal.valueOf(cpInstancePrice));
        if (paymentSubscription) {
            cpInstance.setOverrideSubscriptionInfo(true);
            cpInstance.setSubscriptionEnabled(true);
            cpInstance.setSubscriptionLength(1);
            cpInstance.setSubscriptionType("daily");
            cpInstance.setMaxSubscriptionCycles(2L);
        }
        if (deliverySubscription) {
            cpInstance.setOverrideSubscriptionInfo(true);
            cpInstance.setDeliverySubscriptionEnabled(true);
            cpInstance.setDeliverySubscriptionLength(1);
            cpInstance.setDeliverySubscriptionType("daily");
            cpInstance.setDeliveryMaxSubscriptionCycles(2L);
        }
        CPInstanceLocalServiceUtil.updateCPInstance((CPInstance)cpInstance);
        CommerceInventoryWarehouse commerceInventoryWarehouse = CommerceInventoryTestUtil.addCommerceInventoryWarehouse(ServiceContextTestUtil.getServiceContext((long)groupId));
        CommerceChannel commerceChannel = CommerceChannelLocalServiceUtil.getCommerceChannelByOrderGroupId((long)commerceOrder.getGroupId());
        CommerceTestUtil.addWarehouseCommerceChannelRel(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), commerceChannel.getCommerceChannelId());
        CommerceInventoryTestUtil.addCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouse, cpInstance.getSku(), 10);
        CommerceTestUtil.addCommerceOrderItem(commerceOrder.getCommerceOrderId(), cpInstance.getCPInstanceId(), 4);
        CommerceAddress billingCommerceAddress = CommerceTestUtil.addUserCommerceAddress(groupId, userId);
        CommerceAddress shippingCommerceAddress = CommerceTestUtil.addUserCommerceAddress(groupId, userId);
        commerceOrder = CommerceOrderLocalServiceUtil.getCommerceOrder((long)commerceOrder.getCommerceOrderId());
        commerceOrder.setBillingAddressId(billingCommerceAddress.getCommerceAddressId());
        commerceOrder.setShippingAddressId(shippingCommerceAddress.getCommerceAddressId());
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = CommerceTestUtil.addCommercePaymentMethodGroupRel(userId, commerceChannel.getGroupId());
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodGroupRel.getEngineKey());
        CommerceShippingMethod commerceShippingMethod = CommerceTestUtil.addCommerceShippingMethod(userId, commerceChannel.getGroupId());
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethod.getCommerceShippingMethodId());
        CommerceShippingFixedOption commerceShippingFixedOption = CommerceTestUtil.addCommerceShippingFixedOption(commerceShippingMethod);
        commerceOrder.setShippingAmount(commerceShippingFixedOption.getAmount());
        commerceOrder.setShippingOptionName(commerceShippingFixedOption.getName());
        return CommerceOrderLocalServiceUtil.updateCommerceOrder((CommerceOrder)commerceOrder);
    }

    public static CommerceCatalog addCommerceCatalog(long companyId, long groupId, long userId, String commerceCurrencyCode) throws Exception {
        return CommerceCatalogLocalServiceUtil.addCommerceCatalog(null, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)commerceCurrencyCode, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.US), (ServiceContext)ServiceContextTestUtil.getServiceContext((long)companyId, (long)groupId, (long)userId));
    }

    public static CommerceChannel addCommerceChannel(long groupId, String commerceCurrencyCode) throws Exception {
        return CommerceChannelLocalServiceUtil.addCommerceChannel((String)"", (long)groupId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"site", null, (String)commerceCurrencyCode, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CommerceChannel addCommerceChannel(String commerceCurrencyCode) throws Exception {
        return CommerceChannelLocalServiceUtil.addCommerceChannel((String)"", (long)RandomTestUtil.nextLong(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"site", null, (String)commerceCurrencyCode, (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static CommerceChannelRel addCommerceChannelRel(long groupId, long commerceChannelId, long warehouseId) throws Exception {
        return CommerceChannelRelLocalServiceUtil.addCommerceChannelRel((String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)warehouseId, (long)commerceChannelId, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
    }

    public static CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity) throws Exception {
        CommerceOrder commerceOrder = CommerceOrderLocalServiceUtil.getCommerceOrder((long)commerceOrderId);
        if (commerceOrder.getCommerceCurrency() == null) {
            CommerceCurrency commerceCurrency = CommerceCurrencyTestUtil.addCommerceCurrency((long)commerceOrder.getCompanyId());
            commerceOrder.setCommerceCurrencyId(commerceCurrency.getCommerceCurrencyId());
            CommerceOrderLocalServiceUtil.updateCommerceOrder((CommerceOrder)commerceOrder);
        }
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)commerceOrder.getGroupId());
        TestCommerceContext commerceContext = new TestCommerceContext(commerceOrder.getCommerceCurrency(), null, null, serviceContext.getScopeGroup(), null, commerceOrder);
        return CommerceTestUtil.addCommerceOrderItem(commerceOrderId, cpInstanceId, quantity, commerceContext);
    }

    public static CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, CommerceContext commerceContext) throws Exception {
        CommerceOrder commerceOrder = CommerceOrderLocalServiceUtil.getCommerceOrder((long)commerceOrderId);
        return CommerceOrderItemLocalServiceUtil.addCommerceOrderItem((long)commerceOrderId, (long)cpInstanceId, null, (int)quantity, (int)0, (CommerceContext)commerceContext, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)commerceOrder.getGroupId()));
    }

    public static CommercePaymentMethodGroupRel addCommercePaymentMethodGroupRel(long userId, long groupId) throws Exception {
        Map<Locale, String> nameMap = Collections.singletonMap(LocaleUtil.US, "Test Payment Method Group Rel");
        return CommercePaymentMethodGroupRelLocalServiceUtil.addCommercePaymentMethodGroupRel((long)userId, (long)groupId, nameMap, null, null, (String)"test-payment-method", (double)1.0, (boolean)true);
    }

    public static CommerceShippingFixedOption addCommerceShippingFixedOption(CommerceShippingMethod commerceShippingMethod) throws Exception {
        BigDecimal value = BigDecimal.valueOf(RandomTestUtil.randomDouble());
        return CommerceTestUtil.addCommerceShippingFixedOption(commerceShippingMethod, value);
    }

    public static CommerceShippingFixedOption addCommerceShippingFixedOption(CommerceShippingMethod commerceShippingMethod, BigDecimal value) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)commerceShippingMethod.getGroupId());
        return CommerceShippingFixedOptionLocalServiceUtil.addCommerceShippingFixedOption((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (long)commerceShippingMethod.getCommerceShippingMethodId(), (BigDecimal)value, (Map)RandomTestUtil.randomLocaleStringMap(), null, (Map)RandomTestUtil.randomLocaleStringMap(), (double)1.0);
    }

    public static CommerceShippingMethod addCommerceShippingMethod(long userId, long groupId) throws Exception {
        return CommerceShippingMethodLocalServiceUtil.addCommerceShippingMethod((long)userId, (long)groupId, (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (boolean)true, (String)"fixedPrice", null, (double)1.0, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
    }

    public static CommerceShippingMethod addFixedRateCommerceShippingMethod(long userId, long groupId, BigDecimal value) throws Exception {
        CommerceShippingMethod commerceShippingMethod = CommerceTestUtil.addCommerceShippingMethod(userId, groupId);
        CommerceTestUtil.addCommerceShippingFixedOption(commerceShippingMethod, value);
        return commerceShippingMethod;
    }

    public static CommerceAddress addUserCommerceAddress(long groupId, long userId) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        Country country = CommerceTestUtil._setUpCountry(serviceContext);
        Region region = CommerceTestUtil._setUpRegion(country, serviceContext);
        return CommerceAddressLocalServiceUtil.addCommerceAddress((String)User.class.getName(), (long)userId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)String.valueOf(30133), (long)region.getRegionId(), (long)country.getCountryId(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)false, (boolean)false, (ServiceContext)serviceContext);
    }

    public static CommerceChannelRel addWarehouseCommerceChannelRel(long warehouseId, long commerceChannelId) throws Exception {
        CommerceChannel commerceChannel = CommerceChannelLocalServiceUtil.getCommerceChannel((long)commerceChannelId);
        return CommerceChannelRelLocalServiceUtil.addCommerceChannelRel((String)CommerceInventoryWarehouse.class.getName(), (long)warehouseId, (long)commerceChannelId, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)commerceChannel.getGroupId()));
    }

    public static CommerceOrder createCommerceOrderForShipping(long userId, long groupId, long currencyId, BigDecimal value) throws Exception {
        CommerceOrder commerceOrder = CommerceTestUtil.addB2CCommerceOrder(userId, groupId, currencyId);
        int orderStatusIndex = RandomTestUtil.randomInt((int)0, (int)(CommerceShipmentConstants.ALLOWED_ORDER_STATUSES.length - 1));
        int orderStatus = CommerceShipmentConstants.ALLOWED_ORDER_STATUSES[orderStatusIndex];
        commerceOrder.setOrderStatus(orderStatus);
        CommerceAddress billingCommerceAddress = CommerceTestUtil.addUserCommerceAddress(groupId, userId);
        CommerceAddress shippingCommerceAddress = CommerceTestUtil.addUserCommerceAddress(groupId, userId);
        commerceOrder.setBillingAddressId(billingCommerceAddress.getCommerceAddressId());
        commerceOrder.setShippingAddressId(shippingCommerceAddress.getCommerceAddressId());
        CommerceShippingMethod commerceShippingMethod = CommerceTestUtil.addFixedRateCommerceShippingMethod(userId, commerceOrder.getGroupId(), value);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethod.getCommerceShippingMethodId());
        CommerceShippingFixedOption commerceShippingFixedOption = CommerceTestUtil.addCommerceShippingFixedOption(commerceShippingMethod, value);
        commerceOrder.setShippingAmount(commerceShippingFixedOption.getAmount());
        commerceOrder.setShippingOptionName(commerceShippingFixedOption.getNameCurrentValue());
        return CommerceOrderLocalServiceUtil.updateCommerceOrder((CommerceOrder)commerceOrder);
    }

    public static CPDefinitionInventory updateBackOrderCPDefinitionInventory(CPDefinition cpDefinition) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = CPDefinitionInventoryLocalServiceUtil.fetchCPDefinitionInventoryByCPDefinitionId((long)cpDefinition.getCPDefinitionId());
        if (cpDefinitionInventory != null) {
            cpDefinitionInventory.setBackOrders(true);
            cpDefinitionInventory = CPDefinitionInventoryLocalServiceUtil.updateCPDefinitionInventory((CPDefinitionInventory)cpDefinitionInventory);
        }
        return cpDefinitionInventory;
    }

    private static Country _setUpCountry(ServiceContext serviceContext) throws Exception {
        Country country = CountryLocalServiceUtil.fetchCountryByNumber((long)serviceContext.getCompanyId(), (String)"000");
        if (country == null) {
            country = CountryLocalServiceUtil.addCountry((String)"ZZ", (String)"ZZZ", (boolean)true, (boolean)true, null, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"000", (double)RandomTestUtil.randomDouble(), (boolean)true, (boolean)false, (boolean)false, (ServiceContext)serviceContext);
        }
        return country;
    }

    private static Region _setUpRegion(Country country, ServiceContext serviceContext) throws Exception {
        Region region = RegionLocalServiceUtil.fetchRegion((long)country.getCountryId(), (String)"ZZ");
        if (region != null) {
            return region;
        }
        return RegionLocalServiceUtil.addRegion((long)country.getCountryId(), (boolean)true, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (double)RandomTestUtil.randomDouble(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
    }
}

