/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.test.util;

import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPTaxCategoryLocalServiceUtil;
import com.liferay.commerce.tax.engine.fixed.service.CommerceTaxFixedRateAddressRelLocalServiceUtil;
import com.liferay.commerce.tax.model.CommerceTaxMethod;
import com.liferay.commerce.tax.service.CommerceTaxMethodLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

public class CommerceTaxTestUtil {
    private static final BigDecimal _ONE_HUNDRED = new BigDecimal("100");
    private static final int _SCALE = 10;

    public static CommerceTaxMethod addCommerceByAddressTaxMethod(long userId, long channelGroupId, boolean percentage) throws PortalException {
        String commerceTaxMethodEngineKey = "by-address";
        return CommerceTaxMethodLocalServiceUtil.addCommerceTaxMethod((long)userId, (long)channelGroupId, (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (String)commerceTaxMethodEngineKey, (boolean)percentage, (boolean)true);
    }

    public static long addTaxCategoryId(long groupId) throws PortalException {
        CPTaxCategory cpTaxCategory = CPTaxCategoryLocalServiceUtil.addCPTaxCategory((String)"", (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
        return cpTaxCategory.getCPTaxCategoryId();
    }

    public static long getDefaultCompanyTaxCategory(long groupId) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        List cpTaxCategories = CPTaxCategoryLocalServiceUtil.getCPTaxCategories((long)serviceContext.getCompanyId());
        if (cpTaxCategories.isEmpty()) {
            return CommerceTaxTestUtil.addTaxCategoryId(groupId);
        }
        CPTaxCategory cpTaxCategory = (CPTaxCategory)cpTaxCategories.get(0);
        return cpTaxCategory.getCPTaxCategoryId();
    }

    public static BigDecimal getPriceWithoutTaxAmount(BigDecimal priceWithTaxAmount, BigDecimal taxRate, RoundingMode roundingMode) {
        BigDecimal taxValue = priceWithTaxAmount.multiply(taxRate);
        BigDecimal denominator = _ONE_HUNDRED.add(taxRate);
        taxValue = taxValue.divide(denominator, 10, roundingMode);
        return priceWithTaxAmount.subtract(taxValue);
    }

    public static BigDecimal getPriceWithTaxAmount(BigDecimal price, BigDecimal taxRate, RoundingMode roundingMode) {
        BigDecimal taxValue = price.multiply(taxRate);
        taxValue = taxValue.divide(_ONE_HUNDRED, 10, roundingMode);
        return price.add(taxValue);
    }

    public static void setCommerceMethodTaxRate(long userId, long channelGroupId, long cpTaxCategoryId, long commerceTaxMethodId, double rate) throws PortalException {
        CommerceTaxFixedRateAddressRelLocalServiceUtil.addCommerceTaxFixedRateAddressRel((long)userId, (long)channelGroupId, (long)commerceTaxMethodId, (long)cpTaxCategoryId, (long)0L, (long)0L, (String)"", (double)rate);
    }
}

