/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.term.web.internal.entry.constants;

import com.liferay.account.constants.AccountPortletKeys;
import com.liferay.commerce.term.constants.CommerceTermEntryPortletKeys;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceTermEntryFDSNames {

	public static final String ACCOUNT_ENTRY_DELIVERY_TERM_ENTRIES =
		AccountPortletKeys.ACCOUNT_ENTRIES_ADMIN +
			"-accountEntryDeliveryTermEntries";

	public static final String ACCOUNT_ENTRY_PAYMENT_TERM_ENTRIES =
		AccountPortletKeys.ACCOUNT_ENTRIES_ADMIN +
			"-accountEntryPaymentTermEntries";

	public static final String TERM_ENTRIES =
		CommerceTermEntryPortletKeys.COMMERCE_TERM_ENTRY + "-termEntries";

	public static final String TERM_ENTRY_QUALIFIER_COMMERCE_ORDER_TYPES =
		CommerceTermEntryPortletKeys.COMMERCE_TERM_ENTRY +
			"-termEntryQualifierCommerceOrderTypes";

}