/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.util.comparator;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;

public class CPInstanceSkuComparator
extends OrderByComparator<CPInstance> {
    public static final String ORDER_BY_ASC = "CPInstance.sku ASC";
    public static final String ORDER_BY_DESC = "CPInstance.sku DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"sku"};
    private final boolean _ascending;

    public CPInstanceSkuComparator() {
        this(false);
    }

    public CPInstanceSkuComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(CPInstance cpInstance1, CPInstance cpInstance2) {
        String sku1 = StringUtil.toLowerCase((String)cpInstance1.getSku());
        String sku2 = StringUtil.toLowerCase((String)cpInstance2.getSku());
        int value = sku1.compareTo(sku2);
        if (this._ascending) {
            return value;
        }
        return Math.negateExact(value);
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

