/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.option;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public interface CommerceOptionValue {
    public long getCPInstanceId();

    public CommerceOptionValue getFirstMatch(List<CommerceOptionValue> var1);

    public String getOptionKey();

    public String getOptionValueKey();

    public BigDecimal getPrice();

    public String getPriceType();

    public int getQuantity();

    public boolean matches(CommerceOptionValue var1);

    public String toJSON();

    public static class Builder {
        private static final String _JSON_SERIALIZED_PATTERN = "{\"cpInstanceId\":%d, \"key\":\"%s\", \"price\":\"%s\", \"priceType\":\"%s\", \"quantity\":%d, \"value\":\"%s\"}";
        private long _cpInstanceId;
        private String _optionKey;
        private String _optionValueKey;
        private BigDecimal _price;
        private String _priceType;
        private int _quantity;

        public CommerceOptionValue build() {
            return new CommerceOptionValue(){
                private final long _cpInstanceId;
                private final String _optionKey;
                private final String _optionValueKey;
                private final BigDecimal _price;
                private final String _priceType;
                private final int _quantity;
                {
                    this._cpInstanceId = _cpInstanceId;
                    this._optionKey = _optionKey;
                    this._optionValueKey = _optionValueKey;
                    this._price = _price;
                    this._priceType = _priceType;
                    this._quantity = _quantity;
                }

                @Override
                public long getCPInstanceId() {
                    return this._cpInstanceId;
                }

                @Override
                public CommerceOptionValue getFirstMatch(List<CommerceOptionValue> commerceOptionValues) {
                    for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
                        if (!this.matches(commerceOptionValue)) continue;
                        return commerceOptionValue;
                    }
                    return null;
                }

                @Override
                public String getOptionKey() {
                    return this._optionKey;
                }

                @Override
                public String getOptionValueKey() {
                    return this._optionValueKey;
                }

                @Override
                public BigDecimal getPrice() {
                    return this._price;
                }

                @Override
                public String getPriceType() {
                    return this._priceType;
                }

                @Override
                public int getQuantity() {
                    return this._quantity;
                }

                @Override
                public boolean matches(CommerceOptionValue commerceOptionValue) {
                    if (commerceOptionValue == null) {
                        return false;
                    }
                    return Objects.equals(this._optionKey, commerceOptionValue.getOptionKey()) && Objects.equals(this._optionValueKey, commerceOptionValue.getOptionValueKey());
                }

                @Override
                public String toJSON() {
                    return String.format(Builder._JSON_SERIALIZED_PATTERN, this._cpInstanceId, this._optionKey, this._price, this._priceType, this._quantity, this._optionValueKey);
                }
            };
        }

        public Builder cpInstanceId(long cpInstanceId) {
            this._cpInstanceId = cpInstanceId;
            return this;
        }

        public Builder optionKey(String optionKey) {
            this._optionKey = optionKey;
            return this;
        }

        public Builder optionValueKey(String optionValueKey) {
            this._optionValueKey = optionValueKey;
            return this;
        }

        public Builder price(BigDecimal price) {
            this._price = price;
            return this;
        }

        public Builder priceType(String priceType) {
            this._priceType = priceType;
            return this;
        }

        public Builder quantity(int quantity) {
            this._quantity = quantity;
            return this;
        }
    }
}

