/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.display.context;

import com.liferay.commerce.product.display.context.util.CPRequestHelper;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.portlet.action.ActionHelper;
import com.liferay.commerce.product.type.CPType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseCPDefinitionsDisplayContext {
    protected final ActionHelper actionHelper;
    protected final CPRequestHelper cpRequestHelper;
    protected final HttpServletRequest httpServletRequest;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected final PortalPreferences portalPreferences;
    private CommerceCatalog _commerceCatalog;
    private CPDefinition _cpDefinition;

    public BaseCPDefinitionsDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest) {
        this.actionHelper = actionHelper;
        this.httpServletRequest = httpServletRequest;
        this.portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this.httpServletRequest);
        this.cpRequestHelper = new CPRequestHelper(httpServletRequest);
        this.liferayPortletRequest = this.cpRequestHelper.getLiferayPortletRequest();
        this.liferayPortletResponse = this.cpRequestHelper.getLiferayPortletResponse();
    }

    public String getCatalogDefaultLanguageId() throws PortalException {
        CommerceCatalog commerceCatalog = this.getCommerceCatalog();
        if (commerceCatalog == null) {
            ThemeDisplay themeDisplay = this.cpRequestHelper.getThemeDisplay();
            return LocaleUtil.toLanguageId((Locale)themeDisplay.getSiteDefaultLocale());
        }
        return commerceCatalog.getCatalogDefaultLanguageId();
    }

    public CommerceCatalog getCommerceCatalog() throws PortalException {
        if (this._commerceCatalog != null) {
            return this._commerceCatalog;
        }
        CPDefinition cpDefinition = this.getCPDefinition();
        if (cpDefinition == null) {
            return null;
        }
        this._commerceCatalog = this._cpDefinition.getCommerceCatalog();
        return this._commerceCatalog;
    }

    public long getCommerceCatalogId() throws PortalException {
        CommerceCatalog commerceCatalog = this.getCommerceCatalog();
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    public CPDefinition getCPDefinition() throws PortalException {
        if (this._cpDefinition != null) {
            return this._cpDefinition;
        }
        this._cpDefinition = this.actionHelper.getCPDefinition((PortletRequest)this.cpRequestHelper.getRenderRequest());
        return this._cpDefinition;
    }

    public long getCPDefinitionId() throws PortalException {
        CPDefinition cpDefinition = this.getCPDefinition();
        if (cpDefinition == null) {
            return 0L;
        }
        return cpDefinition.getCPDefinitionId();
    }

    public CPType getCPType() throws PortalException {
        CPDefinition cpDefinition = this.getCPDefinition();
        if (cpDefinition == null) {
            return this.actionHelper.getCPType(ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"productTypeName"));
        }
        return this.actionHelper.getCPType(cpDefinition.getProductTypeName());
    }

    public CPType getCPType(String name) {
        return this.actionHelper.getCPType(name);
    }

    public List<CPType> getCPTypes() {
        return this.actionHelper.getCPTypes();
    }

    public PortletURL getEditProductDefinitionURL() throws PortalException {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "editProductDefinition");
        portletURL.setParameter("cpDefinitionId", String.valueOf(this.getCPDefinitionId()));
        return portletURL;
    }

    public PortletURL getPortletURL() throws PortalException {
        CPDefinition cpDefinition;
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        String redirect = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        if ((cpDefinition = this.getCPDefinition()) != null) {
            portletURL.setParameter("cpDefinitionId", String.valueOf(this.getCPDefinitionId()));
        }
        return portletURL;
    }

    public long getScopeGroupId() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.getScopeGroupId();
    }

    public String getScreenNavigationCategoryKey() {
        return "details";
    }

    public String getSelectedScreenNavigationCategoryKey() {
        return ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"screenNavigationCategoryKey", (String)this.getScreenNavigationCategoryKey());
    }

    public String getSku(CPDefinition cpDefinition, Locale locale) {
        List<CPInstance> cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            return "";
        }
        if (cpInstances.size() > 1) {
            return LanguageUtil.get((Locale)locale, (String)"multiple-skus");
        }
        CPInstance cpInstance = cpInstances.get(0);
        return cpInstance.getSku();
    }
}

