// Generated by delombok at Thu Nov 16 13:48:04 CST 2017
package com.paypal.api.openidconnect;

import com.paypal.base.Constants;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import java.util.HashMap;

/**
 * Class Userinfo
 */
public class Userinfo extends PayPalResource {
	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	private String userId;
	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	private String sub;
	/**
	 * End-User's full name in displayable form including all name parts, possibly including titles and suffixes, ordered according to the End-User's locale and preferences.
	 */
	private String name;
	/**
	 * Given name(s) or first name(s) of the End-User
	 */
	private String givenName;
	/**
	 * Surname(s) or last name(s) of the End-User.
	 */
	private String familyName;
	/**
	 * Middle name(s) of the End-User.
	 */
	private String middleName;
	/**
	 * URL of the End-User's profile picture.
	 */
	private String picture;
	/**
	 * End-User's preferred e-mail address.
	 */
	private String email;
	/**
	 * True if the End-User's e-mail address has been verified; otherwise false.
	 */
	private Boolean emailVerified;
	/**
	 * End-User's gender.
	 */
	private String gender;
	/**
	 * End-User's birthday, represented as an YYYY-MM-DD format. They year MAY be 0000, indicating it is omited. To represent only the year, YYYY format would be used.
	 */
	private String birthday;
	/**
	 * Time zone database representing the End-User's time zone
	 */
	private String zoneinfo;
	/**
	 * End-User's locale.
	 */
	private String locale;
	/**
	 * End-User's preferred telephone number.
	 */
	private String phoneNumber;
	/**
	 * End-User's preferred address.
	 */
	private Address address;
	/**
	 * Verified account status.
	 */
	private Boolean verifiedAccount;
	/**
	 * Account type.
	 */
	private String accountType;
	/**
	 * Account holder age range.
	 */
	private String ageRange;
	/**
	 * Account payer identifier.
	 */
	private String payerId;

	/**
	 * @return End-User's birthday, represented as an YYYY-MM-DD format
	 *
	 * @deprecated PayPal API returns 'birthday', use that instead
	 */
	@Deprecated
	public String getBirthdate() {
		return this.birthday;
	}

	/**
	 * @param birthdate End-User's birthday, represented as an YYYY-MM-DD format
	 *
	 * @deprecated PayPal API returns 'birthday', use that instead
	 */
	@Deprecated
	public void setBirthdate(String birthdate) {
		this.birthday = birthdate;
	}

	/**
	 * Returns user details
	 * @deprecated Please use {@link #getUserinfo(APIContext)} instead.
	 *
	 * @param accessToken
	 * access token
	 * @return Userinfo
	 * @throws PayPalRESTException
	 */
	public static Userinfo getUserinfo(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return getUserinfo(apiContext);
	}

	/**
	 * Returns user details
	 *
	 * @param apiContext
	 * {@link APIContext} to be used for the call.
	 * @return Userinfo
	 * @throws PayPalRESTException
	 */
	public static Userinfo getUserinfo(APIContext apiContext) throws PayPalRESTException {
		String resourcePath = "v1/identity/openidconnect/userinfo?schema=openid";
		String payLoad = "";
		String accessToken = apiContext.fetchAccessToken();
		HashMap<String, String> httpHeaders = new HashMap<String, String>();
		if (!accessToken.startsWith("Bearer ")) {
			accessToken = "Bearer " + accessToken;
		}
		httpHeaders.put(Constants.AUTHORIZATION_HEADER, accessToken);
		apiContext.addHTTPHeaders(httpHeaders);
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Userinfo.class);
	}

	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUserId() {
		return this.userId;
	}

	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	@java.lang.SuppressWarnings("all")
	public String getSub() {
		return this.sub;
	}

	/**
	 * End-User's full name in displayable form including all name parts, possibly including titles and suffixes, ordered according to the End-User's locale and preferences.
	 */
	@java.lang.SuppressWarnings("all")
	public String getName() {
		return this.name;
	}

	/**
	 * Given name(s) or first name(s) of the End-User
	 */
	@java.lang.SuppressWarnings("all")
	public String getGivenName() {
		return this.givenName;
	}

	/**
	 * Surname(s) or last name(s) of the End-User.
	 */
	@java.lang.SuppressWarnings("all")
	public String getFamilyName() {
		return this.familyName;
	}

	/**
	 * Middle name(s) of the End-User.
	 */
	@java.lang.SuppressWarnings("all")
	public String getMiddleName() {
		return this.middleName;
	}

	/**
	 * URL of the End-User's profile picture.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPicture() {
		return this.picture;
	}

	/**
	 * End-User's preferred e-mail address.
	 */
	@java.lang.SuppressWarnings("all")
	public String getEmail() {
		return this.email;
	}

	/**
	 * True if the End-User's e-mail address has been verified; otherwise false.
	 */
	@java.lang.SuppressWarnings("all")
	public Boolean getEmailVerified() {
		return this.emailVerified;
	}

	/**
	 * End-User's gender.
	 */
	@java.lang.SuppressWarnings("all")
	public String getGender() {
		return this.gender;
	}

	/**
	 * End-User's birthday, represented as an YYYY-MM-DD format. They year MAY be 0000, indicating it is omited. To represent only the year, YYYY format would be used.
	 */
	@java.lang.SuppressWarnings("all")
	public String getBirthday() {
		return this.birthday;
	}

	/**
	 * Time zone database representing the End-User's time zone
	 */
	@java.lang.SuppressWarnings("all")
	public String getZoneinfo() {
		return this.zoneinfo;
	}

	/**
	 * End-User's locale.
	 */
	@java.lang.SuppressWarnings("all")
	public String getLocale() {
		return this.locale;
	}

	/**
	 * End-User's preferred telephone number.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPhoneNumber() {
		return this.phoneNumber;
	}

	/**
	 * End-User's preferred address.
	 */
	@java.lang.SuppressWarnings("all")
	public Address getAddress() {
		return this.address;
	}

	/**
	 * Verified account status.
	 */
	@java.lang.SuppressWarnings("all")
	public Boolean getVerifiedAccount() {
		return this.verifiedAccount;
	}

	/**
	 * Account type.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAccountType() {
		return this.accountType;
	}

	/**
	 * Account holder age range.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAgeRange() {
		return this.ageRange;
	}

	/**
	 * Account payer identifier.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPayerId() {
		return this.payerId;
	}

	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	@java.lang.SuppressWarnings("all")
	public void setUserId(final String userId) {
		this.userId = userId;
	}

	/**
	 * Subject - Identifier for the End-User at the Issuer.
	 */
	@java.lang.SuppressWarnings("all")
	public void setSub(final String sub) {
		this.sub = sub;
	}

	/**
	 * End-User's full name in displayable form including all name parts, possibly including titles and suffixes, ordered according to the End-User's locale and preferences.
	 */
	@java.lang.SuppressWarnings("all")
	public void setName(final String name) {
		this.name = name;
	}

	/**
	 * Given name(s) or first name(s) of the End-User
	 */
	@java.lang.SuppressWarnings("all")
	public void setGivenName(final String givenName) {
		this.givenName = givenName;
	}

	/**
	 * Surname(s) or last name(s) of the End-User.
	 */
	@java.lang.SuppressWarnings("all")
	public void setFamilyName(final String familyName) {
		this.familyName = familyName;
	}

	/**
	 * Middle name(s) of the End-User.
	 */
	@java.lang.SuppressWarnings("all")
	public void setMiddleName(final String middleName) {
		this.middleName = middleName;
	}

	/**
	 * URL of the End-User's profile picture.
	 */
	@java.lang.SuppressWarnings("all")
	public void setPicture(final String picture) {
		this.picture = picture;
	}

	/**
	 * End-User's preferred e-mail address.
	 */
	@java.lang.SuppressWarnings("all")
	public void setEmail(final String email) {
		this.email = email;
	}

	/**
	 * True if the End-User's e-mail address has been verified; otherwise false.
	 */
	@java.lang.SuppressWarnings("all")
	public void setEmailVerified(final Boolean emailVerified) {
		this.emailVerified = emailVerified;
	}

	/**
	 * End-User's gender.
	 */
	@java.lang.SuppressWarnings("all")
	public void setGender(final String gender) {
		this.gender = gender;
	}

	/**
	 * End-User's birthday, represented as an YYYY-MM-DD format. They year MAY be 0000, indicating it is omited. To represent only the year, YYYY format would be used.
	 */
	@java.lang.SuppressWarnings("all")
	public void setBirthday(final String birthday) {
		this.birthday = birthday;
	}

	/**
	 * Time zone database representing the End-User's time zone
	 */
	@java.lang.SuppressWarnings("all")
	public void setZoneinfo(final String zoneinfo) {
		this.zoneinfo = zoneinfo;
	}

	/**
	 * End-User's locale.
	 */
	@java.lang.SuppressWarnings("all")
	public void setLocale(final String locale) {
		this.locale = locale;
	}

	/**
	 * End-User's preferred telephone number.
	 */
	@java.lang.SuppressWarnings("all")
	public void setPhoneNumber(final String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

	/**
	 * End-User's preferred address.
	 */
	@java.lang.SuppressWarnings("all")
	public void setAddress(final Address address) {
		this.address = address;
	}

	/**
	 * Verified account status.
	 */
	@java.lang.SuppressWarnings("all")
	public void setVerifiedAccount(final Boolean verifiedAccount) {
		this.verifiedAccount = verifiedAccount;
	}

	/**
	 * Account type.
	 */
	@java.lang.SuppressWarnings("all")
	public void setAccountType(final String accountType) {
		this.accountType = accountType;
	}

	/**
	 * Account holder age range.
	 */
	@java.lang.SuppressWarnings("all")
	public void setAgeRange(final String ageRange) {
		this.ageRange = ageRange;
	}

	/**
	 * Account payer identifier.
	 */
	@java.lang.SuppressWarnings("all")
	public void setPayerId(final String payerId) {
		this.payerId = payerId;
	}
}
