/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal.servlet;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.media.CommerceMediaProvider;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.order.model.CommerceVirtualOrderItem;
import com.liferay.commerce.product.type.virtual.order.model.CommerceVirtualOrderItemFileEntry;
import com.liferay.commerce.product.type.virtual.order.service.CommerceVirtualOrderItemFileEntryLocalService;
import com.liferay.commerce.product.type.virtual.order.service.CommerceVirtualOrderItemService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.http.whiteboard.context.path=/commerce-media", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.media.servlet.CommerceMediaServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-media/*"}, service={Servlet.class})
public class CommerceMediaServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMediaServlet.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;
    @Reference
    private CommerceMediaProvider _commerceMediaProvider;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CommerceVirtualOrderItemFileEntryLocalService _commerceVirtualOrderItemFileEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.type.virtual.order.model.CommerceVirtualOrderItemFileEntry)")
    private ModelResourcePermission<CommerceVirtualOrderItemFileEntry> _commerceVirtualOrderItemFileEntryModelResourcePermission;
    @Reference
    private CommerceVirtualOrderItemService _commerceVirtualOrderItemService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionVirtualSettingLocalService _cpDefinitionVirtualSettingLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private File _file;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
        }
        try {
            User user = this._portal.getUser(httpServletRequest);
            if (user == null) {
                user = this._userLocalService.getGuestUser(this._portal.getCompanyId(httpServletRequest));
            }
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
            PrincipalThreadLocal.setName((long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            httpServletResponse.sendError(404);
            return;
        }
        String contentDisposition = "inline";
        boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
        if (download) {
            contentDisposition = "attachment";
        }
        this._sendMediaBytes(httpServletRequest, httpServletResponse, contentDisposition);
    }

    private FileEntry _getFileEntry(HttpServletRequest httpServletRequest) throws PortalException {
        String path = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            return null;
        }
        String cpAttachmentFileEntryIdParam = pathArray[3];
        if (cpAttachmentFileEntryIdParam.contains("?")) {
            String[] cpAttachmentFileEntryIdParamArray = StringUtil.split((String)cpAttachmentFileEntryIdParam, (String)"?");
            cpAttachmentFileEntryIdParam = cpAttachmentFileEntryIdParamArray[0];
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(GetterUtil.getLongStrict((String)cpAttachmentFileEntryIdParam));
        return this._getFileEntry(cpAttachmentFileEntry.getFileEntryId());
    }

    private FileEntry _getFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private long _getGroupId(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(cpAttachmentFileEntryId);
        String className = cpAttachmentFileEntry.getClassName();
        if (className.equals(AssetCategory.class.getName())) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(cpAttachmentFileEntry.getClassPK());
            try {
                if (AssetCategoryPermission.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (AssetCategory)assetCategory, (String)"VIEW")) {
                    Company company = this._companyLocalService.getCompany(assetCategory.getCompanyId());
                    return company.getGroupId();
                }
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        } else if (className.equals(CPDefinition.class.getName())) {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpAttachmentFileEntry.getClassPK());
            if (commerceAccountId == Long.MIN_VALUE) {
                this._commerceCatalogModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)cpDefinition.getCommerceCatalog(), "VIEW");
            } else {
                this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, cpDefinition.getCPDefinitionId());
            }
            return cpDefinition.getGroupId();
        }
        return 0L;
    }

    private void _sendDefaultMediaBytes(long groupId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        try {
            FileEntry fileEntry = this._commerceMediaProvider.getDefaultImageFileEntry(this._portal.getCompanyId(httpServletRequest), groupId);
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            httpServletResponse.sendError(404);
        }
    }

    private void _sendError(HttpServletResponse httpServletResponse, int status, String message) {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            JSONObject jsonObject = JSONUtil.put((String)"error", (Object)JSONUtil.put((String)"code", (Object)status).put("message", message));
            printWriter.write(jsonObject.toString());
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setStatus(status);
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
            httpServletResponse.setStatus(500);
        }
    }

    private void _sendMediaBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        String path = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        String commerceVirtualOrderItemPath = pathArray[0];
        if ("/virtual-order-item/".contains(commerceVirtualOrderItemPath)) {
            long commerceVirtualOrderItemId = GetterUtil.getLongStrict((String)pathArray[1]);
            long fileEntryId = GetterUtil.getLongStrict((String)pathArray[3]);
            try {
                CommerceVirtualOrderItem commerceVirtualOrderItem = this._commerceVirtualOrderItemService.fetchCommerceVirtualOrderItem(commerceVirtualOrderItemId);
                if (commerceVirtualOrderItem == null) {
                    this._sendError(httpServletResponse, 404, "The commerce virtual order item " + commerceVirtualOrderItemId + " does not exist");
                    return;
                }
                if (!ArrayUtil.contains((long[])TransformUtil.transformToLongArray((Collection)commerceVirtualOrderItem.getCommerceVirtualOrderItemFileEntries(), commerceVirtualOrderItemFileEntry -> commerceVirtualOrderItemFileEntry.getFileEntryId()), (long)fileEntryId)) {
                    this._sendError(httpServletResponse, 404, "The commerce virtual order item file entry " + fileEntryId + " does not exist");
                    this._sendError(httpServletResponse, 404, StringBundler.concat((Object[])new Object[]{"The commerce virtual order item ", commerceVirtualOrderItemId, " does not have commerce virtual order item file ", "entry ", fileEntryId}));
                    return;
                }
                FileEntry fileEntry = this._getFileEntry(fileEntryId);
                if (fileEntry == null) {
                    this._sendError(httpServletResponse, 404, "The file entry " + fileEntryId + " does not exist");
                    return;
                }
                CommerceVirtualOrderItemFileEntry commerceVirtualOrderItemFileEntry2 = this._commerceVirtualOrderItemFileEntryLocalService.fetchCommerceVirtualOrderItemFileEntry(commerceVirtualOrderItemId, fileEntryId);
                if (commerceVirtualOrderItemFileEntry2 == null) {
                    this._sendError(httpServletResponse, 404, "The file entry " + fileEntryId + " does not exist");
                    return;
                }
                if (!this._commerceVirtualOrderItemFileEntryModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceVirtualOrderItemFileEntry2, "DOWNLOAD_COMMERCE_VIRTUAL_ORDER_ITEM")) {
                    this._sendError(httpServletResponse, 401, "You do not have permission to access the requested resource");
                    return;
                }
                ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)"attachment");
                this._commerceVirtualOrderItemFileEntryLocalService.incrementUsages(commerceVirtualOrderItemFileEntry2.getCommerceVirtualOrderItemFileEntryId());
                return;
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                if (portalException instanceof PrincipalException) {
                    this._sendError(httpServletResponse, 401, "You do not have permission to access the requested resource");
                    return;
                }
                this._sendError(httpServletResponse, 500, "An unexpected error occurred");
                return;
            }
        }
        if (pathArray.length >= 6) {
            if ("/virtual-product/".contains(pathArray[2])) {
                this._sendVirtualSettingsMediaBytes(httpServletRequest, httpServletResponse, CPDefinition.class.getName(), false, pathArray);
                return;
            }
            if ("/virtual-product-sample/".contains(pathArray[2])) {
                this._sendVirtualSettingsMediaBytes(httpServletRequest, httpServletResponse, CPDefinition.class.getName(), true, pathArray);
                return;
            }
            if ("/virtual-sku/".contains(pathArray[2])) {
                this._sendVirtualSettingsMediaBytes(httpServletRequest, httpServletResponse, CPInstance.class.getName(), false, pathArray);
                return;
            }
            if ("/virtual-sku-sample/".contains(pathArray[2])) {
                this._sendVirtualSettingsMediaBytes(httpServletRequest, httpServletResponse, CPInstance.class.getName(), true, pathArray);
                return;
            }
        }
        if (pathArray.length < 2) {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            if (groupId == 0L) {
                httpServletResponse.sendError(404);
                return;
            }
            this._sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
            return;
        }
        try {
            long groupId;
            String cpAttachmentFileEntryIdParam = pathArray[3];
            if (cpAttachmentFileEntryIdParam.contains("?")) {
                String[] cpAttachmentFileEntryIdParamArray = StringUtil.split((String)cpAttachmentFileEntryIdParam, (String)"?");
                cpAttachmentFileEntryIdParam = cpAttachmentFileEntryIdParamArray[0];
            }
            if ((groupId = this._getGroupId(GetterUtil.getLongStrict((String)pathArray[1]), GetterUtil.getLongStrict((String)cpAttachmentFileEntryIdParam))) == 0L) {
                httpServletResponse.sendError(404);
                return;
            }
            FileEntry fileEntry = this._getFileEntry(httpServletRequest);
            if (fileEntry == null) {
                this._sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
                return;
            }
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            httpServletResponse.sendError(404);
        }
    }

    private void _sendVirtualSettingsMediaBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String className, boolean sample, String[] pathArray) throws IOException {
        long commerceAccountId = GetterUtil.getLongStrict((String)pathArray[1]);
        long classPK = GetterUtil.getLongStrict((String)pathArray[3]);
        long fileEntryId = GetterUtil.getLongStrict((String)pathArray[5]);
        try {
            CPDefinition cpDefinition = null;
            if (className.equals(CPInstance.class.getName())) {
                CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(classPK);
                if (cpInstance == null) {
                    this._sendError(httpServletResponse, 404, "The commerce product instance " + classPK + " does not exist");
                    return;
                }
                cpDefinition = cpInstance.getCPDefinition();
            } else {
                cpDefinition = this._cpDefinitionLocalService.fetchCPDefinition(classPK);
                if (cpDefinition == null) {
                    this._sendError(httpServletResponse, 404, "The commerce product definition " + classPK + " does not exist");
                    return;
                }
            }
            if (commerceAccountId == Long.MIN_VALUE) {
                this._commerceCatalogModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)cpDefinition.getCommerceCatalog(), "VIEW");
            } else if (sample) {
                this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, cpDefinition.getCPDefinitionId());
            } else {
                this._sendError(httpServletResponse, 401, "You do not have permission to access the requested resource");
                return;
            }
            CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingLocalService.fetchCPDefinitionVirtualSetting(className, classPK);
            if (cpDefinitionVirtualSetting == null) {
                this._sendError(httpServletResponse, 404, "The commerce product definition " + classPK + " is not virtual");
                return;
            }
            FileEntry fileEntry = null;
            if (sample) {
                fileEntry = cpDefinitionVirtualSetting.getSampleFileEntry();
                if (fileEntry == null || fileEntry.getFileEntryId() != fileEntryId) {
                    this._sendError(httpServletResponse, 404, "The file entry " + fileEntryId + " does not exist");
                    return;
                }
            } else {
                if (!ArrayUtil.contains((long[])TransformUtil.transformToLongArray((Collection)cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries(), cpdVirtualSettingFileEntry -> cpdVirtualSettingFileEntry.getFileEntryId()), (long)fileEntryId)) {
                    this._sendError(httpServletResponse, 404, "The file entry " + fileEntryId + " does not exist");
                    return;
                }
                fileEntry = this._getFileEntry(fileEntryId);
            }
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)"attachment");
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            if (portalException instanceof PrincipalException) {
                this._sendError(httpServletResponse, 401, "You do not have permission to access the requested resource");
                return;
            }
            this._sendError(httpServletResponse, 500, "An unexpected error occurred");
        }
    }
}

