/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal.servlet;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.media.CommerceMediaProvider;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.http.whiteboard.context.path=/commerce-media", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.media.servlet.CommerceMediaServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-media/*"}, service={Servlet.class})
public class CommerceMediaServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMediaServlet.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;
    @Reference
    private CommerceMediaProvider _commerceMediaProvider;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private File _file;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
        }
        try {
            User user = this._portal.getUser(httpServletRequest);
            if (user == null) {
                user = this._userLocalService.getDefaultUser(this._portal.getCompanyId(httpServletRequest));
            }
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
            PrincipalThreadLocal.setName((long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            httpServletResponse.sendError(404);
            return;
        }
        String contentDisposition = "inline";
        boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
        if (download) {
            contentDisposition = "attachment";
        }
        this._sendMediaBytes(httpServletRequest, httpServletResponse, contentDisposition);
    }

    private FileEntry _getFileEntry(HttpServletRequest httpServletRequest) throws PortalException {
        String path = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            return null;
        }
        String cpAttachmentFileEntryIdParam = pathArray[3];
        if (cpAttachmentFileEntryIdParam.contains("?")) {
            String[] cpAttachmentFileEntryIdParamArray = StringUtil.split((String)cpAttachmentFileEntryIdParam, (String)"?");
            cpAttachmentFileEntryIdParam = cpAttachmentFileEntryIdParamArray[0];
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(GetterUtil.getLong((String)cpAttachmentFileEntryIdParam));
        return this._getFileEntry(cpAttachmentFileEntry.getFileEntryId());
    }

    private FileEntry _getFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private long _getGroupId(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(cpAttachmentFileEntryId);
        String className = cpAttachmentFileEntry.getClassName();
        if (className.equals(AssetCategory.class.getName())) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(cpAttachmentFileEntry.getClassPK());
            try {
                if (AssetCategoryPermission.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (AssetCategory)assetCategory, (String)"VIEW")) {
                    Company company = this._companyLocalService.getCompany(assetCategory.getCompanyId());
                    return company.getGroupId();
                }
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        } else if (className.equals(CPDefinition.class.getName())) {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpAttachmentFileEntry.getClassPK());
            if (commerceAccountId == Long.MIN_VALUE) {
                this._commerceCatalogModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)cpDefinition.getCommerceCatalog(), "VIEW");
            } else {
                this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, cpDefinition.getCPDefinitionId());
            }
            return cpDefinition.getGroupId();
        }
        return 0L;
    }

    private void _sendDefaultMediaBytes(long groupId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        try {
            FileEntry fileEntry = this._commerceMediaProvider.getDefaultImageFileEntry(this._portal.getCompanyId(httpServletRequest), groupId);
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            httpServletResponse.sendError(404);
        }
    }

    private void _sendMediaBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String contentDisposition) throws IOException {
        String path = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo());
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            if (groupId == 0L) {
                httpServletResponse.sendError(404);
                return;
            }
            this._sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
            return;
        }
        try {
            long groupId;
            String cpAttachmentFileEntryIdParam = pathArray[3];
            if (cpAttachmentFileEntryIdParam.contains("?")) {
                String[] cpAttachmentFileEntryIdParamArray = StringUtil.split((String)cpAttachmentFileEntryIdParam, (String)"?");
                cpAttachmentFileEntryIdParam = cpAttachmentFileEntryIdParamArray[0];
            }
            if ((groupId = this._getGroupId(GetterUtil.getLong((String)pathArray[1]), GetterUtil.getLong((String)cpAttachmentFileEntryIdParam))) == 0L) {
                httpServletResponse.sendError(404);
                return;
            }
            FileEntry fileEntry = this._getFileEntry(httpServletRequest);
            if (fileEntry == null) {
                this._sendDefaultMediaBytes(groupId, httpServletRequest, httpServletResponse, contentDisposition);
                return;
            }
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileEntry.getFileName(), (byte[])this._file.getBytes(fileEntry.getContentStream()), (String)fileEntry.getMimeType(), (String)contentDisposition);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            httpServletResponse.sendError(404);
        }
    }
}

