/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceMediaResolver.class})
public class DefaultCommerceMediaResolver
implements CommerceMediaResolver {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission;
    @Reference
    private Portal _portal;

    public String getDefaultURL(long groupId) {
        return StringBundler.concat((Object[])new Object[]{this._portal.getPathModule(), "/", "commerce-media", "/default/?groupId=", groupId});
    }

    public String getDownloadURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, true, false);
    }

    public String getThumbnailURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, false, true);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, false, false);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId, boolean download, boolean thumbnail) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, download, thumbnail, true);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId, boolean download, boolean thumbnail, boolean secure) throws PortalException {
        StringBundler sb = new StringBundler(9);
        sb.append(this._portal.getPathModule());
        sb.append("/");
        sb.append("commerce-media");
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
        if (cpAttachmentFileEntry == null) {
            HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
            if (httpSession == null) {
                return sb.toString();
            }
            long companyId = GetterUtil.getLong((Object)httpSession.getAttribute("COMPANY_ID"));
            Company company = this._companyLocalService.getCompany(companyId);
            return this.getDefaultURL(company.getGroupId());
        }
        if (secure) {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(cpAttachmentFileEntry.getFileEntryId());
            if (dlFileEntry != null && !cpAttachmentFileEntry.isCDNEnabled() && !this._dlFileEntryModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)dlFileEntry, "VIEW")) {
                return this.getDefaultURL(cpAttachmentFileEntry.getGroupId());
            }
            String className = cpAttachmentFileEntry.getClassName();
            if (className.equals(AssetCategory.class.getName())) {
                AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(cpAttachmentFileEntry.getClassPK());
                if (!AssetCategoryPermission.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (AssetCategory)assetCategory, (String)"VIEW")) {
                    return this.getDefaultURL(cpAttachmentFileEntry.getGroupId());
                }
            } else if (className.equals(CPDefinition.class.getName())) {
                if (commerceAccountId == Long.MIN_VALUE) {
                    CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpAttachmentFileEntry.getClassPK());
                    if (!this._commerceCatalogModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)cpDefinition.getCommerceCatalog(), "VIEW")) {
                        return this.getDefaultURL(cpAttachmentFileEntry.getGroupId());
                    }
                } else if (!this._commerceProductViewPermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, cpAttachmentFileEntry.getClassPK())) {
                    return this.getDefaultURL(cpAttachmentFileEntry.getGroupId());
                }
            }
        }
        if (cpAttachmentFileEntry.isCDNEnabled()) {
            return cpAttachmentFileEntry.getCDNURL();
        }
        sb.append("/accounts/");
        sb.append(commerceAccountId);
        if (cpAttachmentFileEntry.getType() == 0) {
            sb.append("/images/");
        } else if (cpAttachmentFileEntry.getType() == 1) {
            sb.append("/attachments/");
        }
        sb.append(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
        sb.append("?download=");
        sb.append(download);
        return sb.toString();
    }
}

