/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.search.instance.lifecycle;

import com.liferay.commerce.machine.learning.internal.search.index.CommerceMLIndexer;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class CommerceMLIndexerPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMLIndexerPortalInstanceLifecycleListener.class);
    private final List<CommerceMLIndexer> _commerceMLIndexers = new ArrayList<CommerceMLIndexer>();
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;

    public void portalInstanceRegistered(Company company) throws Exception {
        try {
            for (CommerceMLIndexer commerceMLIndexer : this._commerceMLIndexers) {
                commerceMLIndexer.createIndex(this._indexNameBuilder, this._searchCapabilities, this._searchEngineAdapter, company.getCompanyId());
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to add commerce recommend index for company " + company), (Throwable)exception);
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
        try {
            for (CommerceMLIndexer commerceMLIndexer : this._commerceMLIndexers) {
                commerceMLIndexer.dropIndex(this._indexNameBuilder, this._searchCapabilities, this._searchEngineAdapter, company.getCompanyId());
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to remove commerce recommend index for company " + company), (Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._commerceMLIndexers.add(new CommerceMLIndexer("commerce-ml-forecast-mappings.json", "%s-commerce-ml-forecast"));
        this._commerceMLIndexers.add(new CommerceMLIndexer("frequent-pattern-commerce-ml-recommendation-mappings.json", "%s-frequent-pattern-commerce-ml-recommendation"));
        this._commerceMLIndexers.add(new CommerceMLIndexer("product-commerce-ml-recommendation-mappings.json", "%s-product-content-commerce-ml-recommendation"));
        this._commerceMLIndexers.add(new CommerceMLIndexer("product-commerce-ml-recommendation-mappings.json", "%s-product-interaction-commerce-ml-recommendation"));
        this._commerceMLIndexers.add(new CommerceMLIndexer("user-commerce-ml-recommendation-mappings.json", "%s-user-commerce-ml-recommendation"));
    }
}

