/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.search.index;

import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import com.liferay.portal.search.index.IndexNameBuilder;

public class CommerceMLIndexer {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMLIndexer.class);
    private final String _indexMappingFileName;
    private final String _indexNamePattern;

    public CommerceMLIndexer(String indexMappingFileName, String indexNamePattern) {
        this._indexMappingFileName = indexMappingFileName;
        this._indexNamePattern = indexNamePattern;
    }

    public void createIndex(IndexNameBuilder indexNameBuilder, SearchCapabilities searchCapabilities, SearchEngineAdapter searchEngineAdapter, long companyId) {
        if (!searchCapabilities.isCommerceSupported()) {
            return;
        }
        String indexName = IndexNamePatterns.getIndexName(indexNameBuilder, this._indexNamePattern, companyId);
        if (this._indicesExists(searchEngineAdapter, indexName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Index %s already exist", indexName));
            }
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.setMappings(this._readJSON(this._indexMappingFileName));
        createIndexRequest.setSettings(this._readJSON("settings.json"));
        searchEngineAdapter.execute((IndexRequest)createIndexRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Index %s created successfully", indexName));
        }
    }

    public void dropIndex(IndexNameBuilder indexNameBuilder, SearchCapabilities searchCapabilities, SearchEngineAdapter searchEngineAdapter, long companyId) {
        if (!searchCapabilities.isCommerceSupported()) {
            return;
        }
        String indexName = IndexNamePatterns.getIndexName(indexNameBuilder, this._indexNamePattern, companyId);
        if (!this._indicesExists(searchEngineAdapter, indexName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Index %s does not exist", indexName));
            }
            return;
        }
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(new String[]{indexName});
        searchEngineAdapter.execute((IndexRequest)deleteIndexRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Index %s dropped successfully", indexName));
        }
    }

    private boolean _indicesExists(SearchEngineAdapter searchEngineAdapter, String indexName) {
        IndicesExistsIndexRequest indicesExistsIndexRequest = new IndicesExistsIndexRequest(new String[]{indexName});
        IndicesExistsIndexResponse indicesExistsIndexResponse = (IndicesExistsIndexResponse)searchEngineAdapter.execute((IndexRequest)indicesExistsIndexRequest);
        return indicesExistsIndexResponse.isExists();
    }

    private String _readJSON(String fileName) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read(CommerceMLIndexer.class, (String)("/META-INF/search/" + fileName)));
            return jsonObject.toString();
        }
        catch (JSONException jsonException) {
            _log.error((Throwable)jsonException);
            return null;
        }
    }
}

