/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider;

import com.liferay.account.model.AccountEntry;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider.BaseCommerceMLRecommendationCollectionProvider;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendationManager;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.machine.learning.internal.recommendation.configuration.CommerceMLRecommendationsCollectionProviderConfiguration"}, service={InfoCollectionProvider.class})
public class UserCommerceMLRecommendationInfoItemCollectionProvider
extends BaseCommerceMLRecommendationCollectionProvider
implements InfoCollectionProvider<CPDefinition> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference(unbind="-")
    protected CPDefinitionService cpDefinitionService;
    @Reference
    protected Language language;
    @Reference(unbind="-")
    protected UserCommerceMLRecommendationManager userCommerceMLRecommendationManager;
    private static final Log _log = LogFactoryUtil.getLog(UserCommerceMLRecommendationInfoItemCollectionProvider.class);

    public InfoPage<CPDefinition> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        Pagination pagination = collectionQuery.getPagination();
        try {
            List userCommerceMLRecommendations;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            HttpServletRequest httpServletRequest = serviceContext.getRequest();
            CommerceContext commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
            if (commerceContext == null) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            AccountEntry accountEntry = commerceContext.getAccountEntry();
            if (accountEntry == null) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            long[] assetCategoryIds = null;
            if (relatedItem != null) {
                CPDefinition cpDefinition = (CPDefinition)relatedItem;
                AssetEntry assetEntry = this.assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
                assetCategoryIds = assetEntry.getCategoryIds();
            }
            if ((userCommerceMLRecommendations = this.userCommerceMLRecommendationManager.getUserCommerceMLRecommendations(accountEntry.getCompanyId(), accountEntry.getAccountEntryId(), assetCategoryIds)).isEmpty()) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            return InfoPage.of((List)TransformUtil.transform((Collection)ListUtil.subList((List)userCommerceMLRecommendations, (int)pagination.getStart(), (int)pagination.getEnd()), userCommerceMLRecommendation -> {
                try {
                    return this.cpDefinitionService.fetchCPDefinition(userCommerceMLRecommendation.getRecommendedEntryClassPK());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                    return null;
                }
            }), (Pagination)collectionQuery.getPagination(), (int)userCommerceMLRecommendations.size());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return InfoPage.of(Collections.emptyList(), (Pagination)pagination, (int)0);
        }
    }

    public String getLabel(Locale locale) {
        return this.language.get(locale, "user-personalized-recommendations");
    }
}

