/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider;

import com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider.BaseCommerceMLRecommendationCollectionProvider;
import com.liferay.commerce.machine.learning.recommendation.ProductInteractionCommerceMLRecommendationManager;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.machine.learning.internal.recommendation.configuration.CommerceMLRecommendationsCollectionProviderConfiguration"}, service={RelatedInfoItemCollectionProvider.class})
public class ProductInteractionCommerceMLRecommendationRelatedInfoItemCollectionProvider
extends BaseCommerceMLRecommendationCollectionProvider
implements RelatedInfoItemCollectionProvider<CPDefinition, CPDefinition> {
    private static final Log _log = LogFactoryUtil.getLog(ProductInteractionCommerceMLRecommendationRelatedInfoItemCollectionProvider.class);
    @Reference(unbind="-")
    private CPDefinitionService _cpDefinitionService;
    @Reference(unbind="-")
    private ProductInteractionCommerceMLRecommendationManager _productInteractionCommerceMLRecommendationManager;

    public InfoPage<CPDefinition> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        Pagination pagination = collectionQuery.getPagination();
        if (!(relatedItem instanceof CPDefinition)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)pagination, (int)0);
        }
        CPDefinition cpDefinition = (CPDefinition)relatedItem;
        try {
            List productInteractionCommerceMLRecommendations = this._productInteractionCommerceMLRecommendationManager.getProductInteractionCommerceMLRecommendations(cpDefinition.getCompanyId(), cpDefinition.getCPDefinitionId());
            if (productInteractionCommerceMLRecommendations.isEmpty()) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            return InfoPage.of((List)TransformUtil.transform((Collection)ListUtil.subList((List)productInteractionCommerceMLRecommendations, (int)pagination.getStart(), (int)pagination.getEnd()), productInteractionCommerceMLRecommendation -> {
                try {
                    return this._cpDefinitionService.fetchCPDefinition(productInteractionCommerceMLRecommendation.getRecommendedEntryClassPK());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                    return null;
                }
            }), (Pagination)collectionQuery.getPagination(), (int)productInteractionCommerceMLRecommendations.size());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return InfoPage.of(Collections.emptyList(), (Pagination)pagination, (int)0);
        }
    }

    public String getLabel(Locale locale) {
        return "you-may-also-like-product-recommendations";
    }

    public boolean isAvailable() {
        return this.commerceMLRecommendationsCollectionProviderConfiguration.youMayAlsoLikeProductRecommendationsCollectionProviderEnabled();
    }
}

