/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider;

import com.liferay.commerce.machine.learning.internal.recommendation.info.collection.provider.BaseCommerceMLRecommendationCollectionProvider;
import com.liferay.commerce.machine.learning.recommendation.ProductContentCommerceMLRecommendationManager;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.machine.learning.internal.recommendation.configuration.CommerceMLRecommendationsCollectionProviderConfiguration"}, service={RelatedInfoItemCollectionProvider.class})
public class ProductContentCommerceMLRecommendationRelatedInfoItemCollectionProvider
extends BaseCommerceMLRecommendationCollectionProvider
implements RelatedInfoItemCollectionProvider<CPDefinition, CPDefinition> {
    private static final Log _log = LogFactoryUtil.getLog(ProductContentCommerceMLRecommendationRelatedInfoItemCollectionProvider.class);
    @Reference(unbind="-")
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private Language _language;
    @Reference(unbind="-")
    private ProductContentCommerceMLRecommendationManager _productContentCommerceMLRecommendationManager;

    public InfoPage<CPDefinition> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        Pagination pagination = collectionQuery.getPagination();
        if (!(relatedItem instanceof CPDefinition)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)pagination, (int)0);
        }
        CPDefinition cpDefinition = (CPDefinition)relatedItem;
        try {
            List productContentCommerceMLRecommendations = this._productContentCommerceMLRecommendationManager.getProductContentCommerceMLRecommendations(cpDefinition.getCompanyId(), cpDefinition.getCPDefinitionId());
            if (productContentCommerceMLRecommendations.isEmpty()) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            return InfoPage.of((List)TransformUtil.transform((Collection)ListUtil.subList((List)productContentCommerceMLRecommendations, (int)pagination.getStart(), (int)pagination.getEnd()), productContentCommerceMLRecommendation -> {
                try {
                    return this._cpDefinitionService.fetchCPDefinition(productContentCommerceMLRecommendation.getRecommendedEntryClassPK());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                    return null;
                }
            }), (Pagination)collectionQuery.getPagination(), (int)productContentCommerceMLRecommendations.size());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return InfoPage.of(Collections.emptyList(), (Pagination)pagination, (int)0);
        }
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "content-based-product-recommendations");
    }

    public boolean isAvailable() {
        return this.commerceMLRecommendationsCollectionProviderConfiguration.contentBasedProductRecommendationsCollectionProviderEnabled();
    }
}

