/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation.data.source;

import com.liferay.account.model.AccountEntry;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.machine.learning.internal.recommendation.data.source.BaseCommerceMLRecommendationCPDataSource;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendationManager;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.data.source.CPDataSource;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.data.source.name=userCommerceMLRecommendationDataSource"}, service={CPDataSource.class})
public class UserCommerceMLRecommendationCPDataSourceImpl
extends BaseCommerceMLRecommendationCPDataSource {
    public static final String NAME = "userCommerceMLRecommendationDataSource";
    private static final Log _log = LogFactoryUtil.getLog(UserCommerceMLRecommendationCPDataSourceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private Language _language;
    @Reference
    private UserCommerceMLRecommendationManager _userCommerceMLRecommendationManager;

    public String getLabel(Locale locale) {
        return this._language.get(this.getResourceBundle(locale), "user-interaction-based-product-recommendations");
    }

    public String getName() {
        return NAME;
    }

    public CPDataSourceResult getResult(HttpServletRequest httpServletRequest, int start, int end) throws Exception {
        List userCommerceMLRecommendations;
        long groupId = this.portal.getScopeGroupId(httpServletRequest);
        AccountEntry accountEntry = this.commerceAccountHelper.getCurrentAccountEntry(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), httpServletRequest);
        if (accountEntry == null) {
            return new CPDataSourceResult(Collections.emptyList(), 0);
        }
        CPCatalogEntry cpCatalogEntry = (CPCatalogEntry)httpServletRequest.getAttribute("CP_CATALOG_ENTRY");
        long[] categoryIds = null;
        if (cpCatalogEntry != null) {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpCatalogEntry.getCPDefinitionId());
            categoryIds = assetEntry.getCategoryIds();
        }
        if ((userCommerceMLRecommendations = this._userCommerceMLRecommendationManager.getUserCommerceMLRecommendations(this.portal.getCompanyId(httpServletRequest), accountEntry.getAccountEntryId(), categoryIds)).isEmpty()) {
            return new CPDataSourceResult(Collections.emptyList(), 0);
        }
        ArrayList<CPCatalogEntry> cpCatalogEntries = new ArrayList<CPCatalogEntry>();
        List userCommerceMLRecommendationList = ListUtil.subList((List)userCommerceMLRecommendations, (int)start, (int)end);
        for (UserCommerceMLRecommendation userCommerceMLRecommendation : userCommerceMLRecommendationList) {
            long recommendedEntryClassPK = userCommerceMLRecommendation.getRecommendedEntryClassPK();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)StringBundler.concat((Object[])new Object[]{"Recommended item: ", recommendedEntryClassPK, " score: ", Float.valueOf(userCommerceMLRecommendation.getScore())}));
            }
            try {
                CPCatalogEntry recommendedCPCatalogEntry = this.cpDefinitionHelper.getCPCatalogEntry(accountEntry.getAccountEntryId(), groupId, recommendedEntryClassPK, this.portal.getLocale(httpServletRequest));
                cpCatalogEntries.add(recommendedCPCatalogEntry);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return new CPDataSourceResult(cpCatalogEntries, userCommerceMLRecommendations.size());
    }
}

