/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation.data.source;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.machine.learning.internal.recommendation.data.source.BaseCommerceMLRecommendationCPDataSource;
import com.liferay.commerce.machine.learning.recommendation.FrequentPatternCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.FrequentPatternCommerceMLRecommendationManager;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.data.source.CPDataSource;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.data.source.name=frequentPatternCommerceMLRecommendationDataSource"}, service={CPDataSource.class})
public class FrequentPatternCommerceMLRecommendationCPDataSourceImpl
extends BaseCommerceMLRecommendationCPDataSource {
    public static final String NAME = "frequentPatternCommerceMLRecommendationDataSource";
    private static final Log _log = LogFactoryUtil.getLog(FrequentPatternCommerceMLRecommendationCPDataSourceImpl.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(unbind="-")
    private FrequentPatternCommerceMLRecommendationManager _frequentPatternCommerceMLRecommendationManager;
    @Reference
    private Language _language;

    public String getLabel(Locale locale) {
        return this._language.get(this.getResourceBundle(locale), "frequent-pattern-recommendations");
    }

    public String getName() {
        return NAME;
    }

    public CPDataSourceResult getResult(HttpServletRequest httpServletRequest, int start, int end) throws Exception {
        long groupId = this.portal.getScopeGroupId(httpServletRequest);
        AccountEntry accountEntry = this.commerceAccountHelper.getCurrentAccountEntry(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), httpServletRequest);
        if (accountEntry == null) {
            return new CPDataSourceResult(Collections.emptyList(), 0);
        }
        CPCatalogEntry cpCatalogEntry = (CPCatalogEntry)httpServletRequest.getAttribute("CP_CATALOG_ENTRY");
        if (cpCatalogEntry == null) {
            return new CPDataSourceResult(Collections.emptyList(), 0);
        }
        List frequentPatternCommerceMLRecommendations = this._frequentPatternCommerceMLRecommendationManager.getFrequentPatternCommerceMLRecommendations(this.portal.getCompanyId(httpServletRequest), new long[]{cpCatalogEntry.getCPDefinitionId()});
        if (frequentPatternCommerceMLRecommendations.isEmpty()) {
            return new CPDataSourceResult(Collections.emptyList(), 0);
        }
        ArrayList<CPCatalogEntry> cpCatalogEntries = new ArrayList<CPCatalogEntry>();
        List frequentPatternCommerceMLRecommendationList = ListUtil.subList((List)frequentPatternCommerceMLRecommendations, (int)start, (int)end);
        for (FrequentPatternCommerceMLRecommendation frequentPatternCommerceMLRecommendation : frequentPatternCommerceMLRecommendationList) {
            long recommendedEntryClassPK = frequentPatternCommerceMLRecommendation.getRecommendedEntryClassPK();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)StringBundler.concat((Object[])new Object[]{"Recommended entry ", recommendedEntryClassPK, " has score ", Float.valueOf(frequentPatternCommerceMLRecommendation.getScore())}));
            }
            try {
                CPCatalogEntry recommendedCPCatalogEntry = this.cpDefinitionHelper.getCPCatalogEntry(accountEntry.getAccountEntryId(), groupId, recommendedEntryClassPK, this.portal.getLocale(httpServletRequest));
                cpCatalogEntries.add(recommendedCPCatalogEntry);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return new CPDataSourceResult(cpCatalogEntries, frequentPatternCommerceMLRecommendations.size());
    }
}

