/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation;

import com.liferay.commerce.machine.learning.internal.recommendation.BaseCommerceMLRecommendationServiceImpl;
import com.liferay.commerce.machine.learning.internal.recommendation.UserCommerceMLRecommendationImpl;
import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendationManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UserCommerceMLRecommendationManager.class})
public class UserCommerceMLRecommendationManagerImpl
extends BaseCommerceMLRecommendationServiceImpl<UserCommerceMLRecommendation>
implements UserCommerceMLRecommendationManager {
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public UserCommerceMLRecommendation addUserCommerceMLRecommendation(UserCommerceMLRecommendation userCommerceMLRecommendation) throws PortalException {
        return this.addCommerceMLRecommendation(userCommerceMLRecommendation, this._getIndexName(userCommerceMLRecommendation.getCompanyId()));
    }

    public UserCommerceMLRecommendation create() {
        return new UserCommerceMLRecommendationImpl();
    }

    public List<UserCommerceMLRecommendation> getUserCommerceMLRecommendations(final long companyId, final long commerceAccountId, long[] assetCategoryIds) throws PortalException {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._getIndexName(companyId)});
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (assetCategoryIds != null) {
            for (long categoryId : assetCategoryIds) {
                TermQueryImpl categoryIdTermQuery = new TermQueryImpl("assetCategoryIds", String.valueOf(categoryId));
                booleanQuery.add((Query)categoryIdTermQuery, BooleanClauseOccur.MUST);
            }
        }
        booleanQuery.setPreBooleanFilter(new BooleanFilter(){
            {
                this.add((Filter)new TermFilter("companyId", String.valueOf(companyId)), BooleanClauseOccur.MUST);
                this.add((Filter)new TermFilter("entryClassPK", String.valueOf(commerceAccountId)), BooleanClauseOccur.MUST);
            }
        });
        searchSearchRequest.setQuery((Query)booleanQuery);
        searchSearchRequest.setSize(Integer.valueOf(10));
        Sort sort = SortFactoryUtil.create((String)"score", (int)5, (boolean)true);
        searchSearchRequest.setSorts(new Sort[]{sort});
        searchSearchRequest.setStats(Collections.emptyMap());
        return this.getSearchResults(searchSearchRequest);
    }

    @Override
    protected Document toDocument(UserCommerceMLRecommendation model) {
        Document document = this.getDocument(model);
        document.addKeyword("uid", String.valueOf(this.getHash(model.getEntryClassPK(), model.getRecommendedEntryClassPK())));
        document.addNumber("assetCategoryIds", model.getAssetCategoryIds());
        document.addNumber("entryClassPK", model.getEntryClassPK());
        return document;
    }

    @Override
    protected UserCommerceMLRecommendation toModel(Document document) {
        UserCommerceMLRecommendation userCommerceMLRecommendation = this.getCommerceMLRecommendation(new UserCommerceMLRecommendationImpl(), document);
        userCommerceMLRecommendation.setAssetCategoryIds(GetterUtil.getLongValues((String[])document.getValues("assetCategoryIds")));
        userCommerceMLRecommendation.setEntryClassPK(GetterUtil.getLong((String)document.get("entryClassPK")));
        return userCommerceMLRecommendation;
    }

    private String _getIndexName(long companyId) {
        return IndexNamePatterns.getIndexName(this._indexNameBuilder, "%s-user-commerce-ml-recommendation", companyId);
    }
}

