/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation;

import com.liferay.commerce.machine.learning.internal.recommendation.BaseCommerceMLRecommendationServiceImpl;
import com.liferay.commerce.machine.learning.internal.recommendation.ProductInteractionCommerceMLRecommendationImpl;
import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.commerce.machine.learning.recommendation.ProductInteractionCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.ProductInteractionCommerceMLRecommendationManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProductInteractionCommerceMLRecommendationManager.class})
public class ProductInteractionCommerceMLRecommendationManagerImpl
extends BaseCommerceMLRecommendationServiceImpl<ProductInteractionCommerceMLRecommendation>
implements ProductInteractionCommerceMLRecommendationManager {
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public ProductInteractionCommerceMLRecommendation addProductInteractionCommerceMLRecommendation(ProductInteractionCommerceMLRecommendation productInteractionCommerceMLRecommendation) throws PortalException {
        return this.addCommerceMLRecommendation(productInteractionCommerceMLRecommendation, this._getIndexName(productInteractionCommerceMLRecommendation.getCompanyId()));
    }

    public ProductInteractionCommerceMLRecommendation create() {
        return new ProductInteractionCommerceMLRecommendationImpl();
    }

    public List<ProductInteractionCommerceMLRecommendation> getProductInteractionCommerceMLRecommendations(long companyId, long cpDefinition) throws PortalException {
        SearchSearchRequest searchSearchRequest = this.getSearchSearchRequest(this._getIndexName(companyId), companyId, cpDefinition);
        Sort sort = SortFactoryUtil.create((String)"rank", (int)4, (boolean)false);
        searchSearchRequest.setSorts(new Sort[]{sort});
        return this.getSearchResults(searchSearchRequest);
    }

    @Override
    protected Document toDocument(ProductInteractionCommerceMLRecommendation model) {
        Document document = this.getDocument(model);
        document.addKeyword("uid", String.valueOf(this.getHash(model.getEntryClassPK(), model.getRecommendedEntryClassPK())));
        document.addNumber("rank", model.getRank());
        document.addNumber("entryClassPK", model.getEntryClassPK());
        return document;
    }

    @Override
    protected ProductInteractionCommerceMLRecommendation toModel(Document document) {
        ProductInteractionCommerceMLRecommendation productInteractionCommerceMLRecommendationModel = this.getCommerceMLRecommendation(new ProductInteractionCommerceMLRecommendationImpl(), document);
        productInteractionCommerceMLRecommendationModel.setEntryClassPK(GetterUtil.getLong((String)document.get("entryClassPK")));
        productInteractionCommerceMLRecommendationModel.setRank(GetterUtil.getInteger((String)document.get("rank")));
        return productInteractionCommerceMLRecommendationModel;
    }

    private String _getIndexName(long companyId) {
        return IndexNamePatterns.getIndexName(this._indexNameBuilder, "%s-product-interaction-commerce-ml-recommendation", companyId);
    }
}

