/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation;

import com.liferay.commerce.machine.learning.internal.recommendation.BaseCommerceMLRecommendationServiceImpl;
import com.liferay.commerce.machine.learning.internal.recommendation.ProductContentCommerceMLRecommendationImpl;
import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.commerce.machine.learning.recommendation.ProductContentCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.ProductContentCommerceMLRecommendationManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProductContentCommerceMLRecommendationManager.class})
public class ProductContentCommerceMLRecommendationManagerImpl
extends BaseCommerceMLRecommendationServiceImpl<ProductContentCommerceMLRecommendation>
implements ProductContentCommerceMLRecommendationManager {
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public ProductContentCommerceMLRecommendation addProductContentCommerceMLRecommendation(ProductContentCommerceMLRecommendation productContentCommerceMLRecommendation) throws PortalException {
        return this.addCommerceMLRecommendation(productContentCommerceMLRecommendation, this._getIndexName(productContentCommerceMLRecommendation.getCompanyId()));
    }

    public ProductContentCommerceMLRecommendation create() {
        return new ProductContentCommerceMLRecommendationImpl();
    }

    public List<ProductContentCommerceMLRecommendation> getProductContentCommerceMLRecommendations(long companyId, long cpDefinition) throws PortalException {
        SearchSearchRequest searchSearchRequest = this.getSearchSearchRequest(this._getIndexName(companyId), companyId, cpDefinition);
        Sort sort = SortFactoryUtil.create((String)"rank", (int)4, (boolean)false);
        searchSearchRequest.setSorts(new Sort[]{sort});
        return this.getSearchResults(searchSearchRequest);
    }

    @Override
    protected Document toDocument(ProductContentCommerceMLRecommendation model) {
        Document document = this.getDocument(model);
        document.addKeyword("uid", String.valueOf(this.getHash(model.getEntryClassPK(), model.getRecommendedEntryClassPK())));
        document.addNumber("rank", model.getRank());
        document.addNumber("entryClassPK", model.getEntryClassPK());
        return document;
    }

    @Override
    protected ProductContentCommerceMLRecommendation toModel(Document document) {
        ProductContentCommerceMLRecommendation productContentCommerceMLRecommendation = this.getCommerceMLRecommendation(new ProductContentCommerceMLRecommendationImpl(), document);
        productContentCommerceMLRecommendation.setEntryClassPK(GetterUtil.getLong((String)document.get("entryClassPK")));
        productContentCommerceMLRecommendation.setRank(GetterUtil.getInteger((String)document.get("rank")));
        return productContentCommerceMLRecommendation;
    }

    private String _getIndexName(long companyId) {
        return IndexNamePatterns.getIndexName(this._indexNameBuilder, "%s-product-content-commerce-ml-recommendation", companyId);
    }
}

