/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation;

import com.liferay.commerce.machine.learning.internal.recommendation.BaseCommerceMLRecommendationServiceImpl;
import com.liferay.commerce.machine.learning.internal.recommendation.FrequentPatternCommerceMLRecommendationImpl;
import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.commerce.machine.learning.recommendation.FrequentPatternCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.FrequentPatternCommerceMLRecommendationManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.FunctionScoreQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.query.function.CombineFunction;
import com.liferay.portal.search.query.function.score.ScoreFunction;
import com.liferay.portal.search.query.function.score.ScoreFunctions;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.search.script.Scripts;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FrequentPatternCommerceMLRecommendationManager.class})
public class FrequentPatternCommerceMLRecommendationManagerImpl
extends BaseCommerceMLRecommendationServiceImpl<FrequentPatternCommerceMLRecommendation>
implements FrequentPatternCommerceMLRecommendationManager {
    private static final int _DOCUMENTS_SIZE = 10;
    private static final int _SEARCH_SEARCH_REQUEST_SIZE = 300;
    private static final Log _log = LogFactoryUtil.getLog(FrequentPatternCommerceMLRecommendationManagerImpl.class);
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private ScoreFunctions _scoreFunctions;
    @Reference
    private Scripts _scripts;

    public FrequentPatternCommerceMLRecommendation addFrequentPatternCommerceMLRecommendation(FrequentPatternCommerceMLRecommendation frequentPatternCommerceMLRecommendation) throws PortalException {
        return this.addCommerceMLRecommendation(frequentPatternCommerceMLRecommendation, this._getIndexName(frequentPatternCommerceMLRecommendation.getCompanyId()));
    }

    public FrequentPatternCommerceMLRecommendation create() {
        return new FrequentPatternCommerceMLRecommendationImpl();
    }

    public List<FrequentPatternCommerceMLRecommendation> getFrequentPatternCommerceMLRecommendations(long companyId, long[] cpDefinitionIds) throws PortalException {
        long startTimeMillis = System.currentTimeMillis();
        SearchSearchRequest searchSearchRequest = this._getSearchSearchRequest(companyId, cpDefinitionIds);
        int start = 0;
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>(10, 1.0f);
        while (documents.size() < 10) {
            searchSearchRequest.setStart(Integer.valueOf(start));
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            Hits hits = searchSearchResponse.getHits();
            for (Document document : hits.getDocs()) {
                String recommendedEntryClassPK = document.get("recommendedEntryClassPK");
                if (documents.get(recommendedEntryClassPK) != null) continue;
                documents.put(recommendedEntryClassPK, document);
                if (documents.size() == 10) break;
            }
            if ((long)(start += 300) <= searchSearchResponse.getCount()) continue;
            break;
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("Query execution time: %s", System.currentTimeMillis() - startTimeMillis));
        }
        return this.toList(new ArrayList<Document>(documents.values()));
    }

    @Override
    protected Document toDocument(FrequentPatternCommerceMLRecommendation model) {
        Document document = this.getDocument(model);
        document.addKeyword("uid", String.valueOf(this.getHash(model.getAntecedentIds(), model.getRecommendedEntryClassPK())));
        document.addKeyword("antecedentIds", model.getAntecedentIds());
        document.addNumber("antecedentIdsLength", model.getAntecedentIdsLength());
        return document;
    }

    @Override
    protected FrequentPatternCommerceMLRecommendation toModel(Document document) {
        FrequentPatternCommerceMLRecommendation frequentPatternCommerceMLRecommendation = this.getCommerceMLRecommendation(new FrequentPatternCommerceMLRecommendationImpl(), document);
        frequentPatternCommerceMLRecommendation.setAntecedentIds(GetterUtil.getLongValues((String[])document.getValues("antecedentIds")));
        frequentPatternCommerceMLRecommendation.setAntecedentIdsLength(GetterUtil.getLong((String)document.get("antecedentIdsLength")));
        return frequentPatternCommerceMLRecommendation;
    }

    private BooleanQuery _getConstantScoreQuery(long[] cpInstanceIds) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        for (long cpInstanceId : cpInstanceIds) {
            TermQuery termQuery = this._queries.term("antecedentIds", (Object)cpInstanceId);
            booleanQuery.addShouldQueryClauses(new Query[]{this._queries.constantScore((Query)termQuery)});
        }
        return booleanQuery;
    }

    private BooleanQuery _getExcludeRecommendations(long[] cpInstanceIds) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        for (long cpInstanceId : cpInstanceIds) {
            booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("recommendedEntryClassPK", (Object)cpInstanceId)});
        }
        return booleanQuery;
    }

    private String _getIndexName(long companyId) {
        return IndexNamePatterns.getIndexName(this._indexNameBuilder, "%s-frequent-pattern-commerce-ml-recommendation", companyId);
    }

    private Script _getScript(long[] cpInstanceIds) {
        ScriptBuilder scriptBuilder = this._scripts.builder();
        return scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"/com/liferay/commerce/machine/learning/internal/dependencies/frequent-pattern-commerce-ml-recommendation-script.painless")).language("painless").putParameter("cpInstanceIds", (Object)cpInstanceIds).scriptType(ScriptType.INLINE).build();
    }

    private SearchSearchRequest _getSearchSearchRequest(final long companyId, long[] cpDefinitionIds) {
        final FunctionScoreQuery functionScoreQuery = this._queries.functionScore((Query)this._getConstantScoreQuery(cpDefinitionIds));
        functionScoreQuery.addFilterQueryScoreFunctionHolder((Query)this._getExcludeRecommendations(cpDefinitionIds), (ScoreFunction)this._scoreFunctions.script(this._getScript(cpDefinitionIds)));
        functionScoreQuery.setCombineFunction(CombineFunction.REPLACE);
        functionScoreQuery.setScoreMode(FunctionScoreQuery.ScoreMode.SUM);
        functionScoreQuery.setMinScore(Float.valueOf(1.1f));
        return new SearchSearchRequest(){
            {
                this.setIndexNames(new String[]{FrequentPatternCommerceMLRecommendationManagerImpl.this._getIndexName(companyId)});
                this.setQuery((Query)functionScoreQuery);
                this.setSize(300);
            }
        };
    }
}

