/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.recommendation;

import com.liferay.commerce.machine.learning.recommendation.CommerceMLRecommendation;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceMLRecommendationServiceImpl<T extends CommerceMLRecommendation> {
    protected static final int SEARCH_SEARCH_REQUEST_SIZE = 10;
    @Reference
    protected volatile SearchEngineAdapter searchEngineAdapter;
    private static final String _INDEX_DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceMLRecommendationServiceImpl.class);

    protected T addCommerceMLRecommendation(T model, String indexName) throws PortalException {
        Document document = this.toDocument(model);
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
        IndexDocumentResponse indexDocumentResponse = (IndexDocumentResponse)this.searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
        if (indexDocumentResponse.getStatus() < 200 || indexDocumentResponse.getStatus() >= 300) {
            throw new PortalException(String.format("Index request return status: %d", indexDocumentResponse.getStatus()));
        }
        return model;
    }

    protected T getCommerceMLRecommendation(T commerceMLRecommendation, Document document) {
        commerceMLRecommendation.setCompanyId(GetterUtil.getLong((String)document.get("companyId")));
        commerceMLRecommendation.setCreateDate(this._getDate(document.get("createDate")));
        commerceMLRecommendation.setJobId(document.get("jobId"));
        commerceMLRecommendation.setRecommendedEntryClassPK(GetterUtil.getLong((String)document.get("recommendedEntryClassPK")));
        commerceMLRecommendation.setScore(GetterUtil.getFloat((String)document.get("score")));
        return commerceMLRecommendation;
    }

    protected Document getDocument(T commerceMLRecommend) {
        DocumentImpl document = new DocumentImpl();
        document.addDate("createDate", commerceMLRecommend.getCreateDate());
        document.addNumber("companyId", commerceMLRecommend.getCompanyId());
        document.addNumber("recommendedEntryClassPK", commerceMLRecommend.getRecommendedEntryClassPK());
        document.addNumber("score", commerceMLRecommend.getScore());
        document.addText("jobId", commerceMLRecommend.getJobId());
        return document;
    }

    protected long getHash(Object ... values) {
        StringBundler sb = new StringBundler(values.length);
        for (Object value : values) {
            sb.append(value);
        }
        return HashUtil.hash((int)values.length, (Object)sb.toString());
    }

    protected List<T> getSearchResults(SearchSearchRequest searchSearchRequest) {
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        return this.toList(searchSearchResponse.getHits());
    }

    protected SearchSearchRequest getSearchSearchRequest(final String indexName, final long companyId, final long entryClassPK) {
        final BooleanFilter booleanFilter = new BooleanFilter(){
            {
                this.add((Filter)new TermFilter("companyId", String.valueOf(companyId)), BooleanClauseOccur.MUST);
                this.add((Filter)new TermFilter("entryClassPK", String.valueOf(entryClassPK)), BooleanClauseOccur.MUST);
            }
        };
        return new SearchSearchRequest(){
            {
                this.setIndexNames(new String[]{indexName});
                this.setQuery((Query)new BooleanQueryImpl(){
                    {
                        this.setPreBooleanFilter(booleanFilter);
                    }
                });
                this.setSize(10);
                this.setStats(Collections.emptyMap());
            }
        };
    }

    protected abstract Document toDocument(T var1);

    protected List<T> toList(Hits hits) {
        return this.toList(this._getDocuments(hits));
    }

    protected List<T> toList(List<Document> documents) {
        return TransformUtil.transform(documents, this::toModel);
    }

    protected abstract T toModel(Document var1);

    private Date _getDate(String dateString) {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_INDEX_DATE_FORMAT_PATTERN);
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            return null;
        }
    }

    private List<Document> _getDocuments(Hits hits) {
        ArrayList<Document> documents = new ArrayList<Document>(hits.toList());
        Map groupedHits = hits.getGroupedHits();
        for (Map.Entry entry : groupedHits.entrySet()) {
            documents.addAll(this._getDocuments((Hits)entry.getValue()));
        }
        return documents;
    }
}

