/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.forecast;

import com.liferay.commerce.machine.learning.forecast.SkuCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.SkuCommerceMLForecastManager;
import com.liferay.commerce.machine.learning.internal.forecast.BaseCommerceMLForecastServiceImpl;
import com.liferay.commerce.machine.learning.internal.forecast.SkuCommerceMLForecastImpl;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastPeriod;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastScope;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastTarget;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(service={SkuCommerceMLForecastManager.class})
public class SkuCommerceMLForecastManagerImpl
extends BaseCommerceMLForecastServiceImpl<SkuCommerceMLForecast>
implements SkuCommerceMLForecastManager {
    private static final CommerceMLForecastScope _commerceMLForecastScope = CommerceMLForecastScope.SKU;

    public SkuCommerceMLForecast addSkuCommerceMLForecast(SkuCommerceMLForecast skuCommerceMLForecast) throws PortalException {
        long commerceMLForecastId = this.getHash(skuCommerceMLForecast.getPeriod(), skuCommerceMLForecast.getScope(), skuCommerceMLForecast.getSku(), skuCommerceMLForecast.getTarget(), skuCommerceMLForecast.getTimestamp());
        skuCommerceMLForecast.setForecastId(commerceMLForecastId);
        return this.addCommerceMLForecast(skuCommerceMLForecast);
    }

    public SkuCommerceMLForecast create() {
        return new SkuCommerceMLForecastImpl(){
            {
                this.setScope(_commerceMLForecastScope.getLabel());
            }
        };
    }

    public List<SkuCommerceMLForecast> getMonthlyQuantitySkuCommerceMLForecasts(long companyId, String sku, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        return this.getMonthlyQuantitySkuCommerceMLForecasts(companyId, sku, actualDate, historyLength, forecastLength, 0, forecastLength + historyLength);
    }

    public List<SkuCommerceMLForecast> getMonthlyQuantitySkuCommerceMLForecasts(long companyId, String sku, Date actualDate, int historyLength, int forecastLength, int start, int end) throws PortalException {
        return this.getMonthlyQuantitySkuCommerceMLForecasts(companyId, new String[]{sku}, actualDate, historyLength, forecastLength, 0, forecastLength + historyLength);
    }

    public List<SkuCommerceMLForecast> getMonthlyQuantitySkuCommerceMLForecasts(long companyId, String[] skus, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        return this.getMonthlyQuantitySkuCommerceMLForecasts(companyId, skus, actualDate, historyLength, forecastLength, 0, forecastLength + historyLength);
    }

    public List<SkuCommerceMLForecast> getMonthlyQuantitySkuCommerceMLForecasts(long companyId, String[] skus, Date actualDate, int historyLength, int forecastLength, int start, int end) throws PortalException {
        return this.getSearchResults(this.getSearchSearchRequest(this.getIndexName(companyId), this._getMonthlyQuantityQuery(skus, actualDate, historyLength, forecastLength), start, end - start, this.getDefaultSort(true)));
    }

    public long getMonthlyQuantitySkuCommerceMLForecastsCount(long companyId, String sku, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        return this.getMonthlyQuantitySkuCommerceMLForecastsCount(companyId, new String[]{sku}, actualDate, historyLength, forecastLength);
    }

    public long getMonthlyQuantitySkuCommerceMLForecastsCount(long companyId, String[] skus, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        return this.getCountResult(this.getCountSearchRequest(this.getIndexName(companyId), this._getMonthlyQuantityQuery(skus, actualDate, historyLength, forecastLength)));
    }

    public SkuCommerceMLForecast getSkuCommerceMLForecast(long companyId, long forecastId) throws PortalException {
        return (SkuCommerceMLForecast)this.getCommerceMLForecast(companyId, forecastId);
    }

    @Override
    protected Document toDocumentModel(SkuCommerceMLForecast skuCommerceMLForecast) {
        Document document = this.getDocument(skuCommerceMLForecast);
        document.addText("sku", skuCommerceMLForecast.getSku());
        return document;
    }

    @Override
    protected SkuCommerceMLForecast toForecastModel(Document document) {
        SkuCommerceMLForecast skuCommerceMLForecast = this.getCommerceMLForecastModel(new SkuCommerceMLForecastImpl(), document);
        skuCommerceMLForecast.setSku(document.get("sku"));
        return skuCommerceMLForecast;
    }

    private Query _getMonthlyQuantityQuery(final String[] sku, Date actualDate, int historyLength, int forecastLength) throws ParseException {
        CommerceMLForecastPeriod commerceMLForecastPeriod = CommerceMLForecastPeriod.MONTH;
        CommerceMLForecastTarget commerceMLForecastTarget = CommerceMLForecastTarget.QUANTITY;
        BooleanQuery booleanQuery = this.getBooleanQuery(_commerceMLForecastScope.getLabel(), commerceMLForecastPeriod.getLabel(), commerceMLForecastTarget.getLabel(), this.getStartDate(actualDate, commerceMLForecastPeriod, historyLength), this.getEndDate(actualDate, commerceMLForecastPeriod, forecastLength));
        BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
        preBooleanFilter.add((Filter)new TermsFilter("sku"){
            {
                super(x0);
                this.addValues(ArrayUtil.toStringArray((Object[])sku));
            }
        }, BooleanClauseOccur.MUST);
        return booleanQuery;
    }
}

