/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.forecast;

import com.liferay.commerce.machine.learning.forecast.CommerceMLForecast;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastPeriod;
import com.liferay.commerce.machine.learning.internal.search.constants.IndexNamePatterns;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceMLForecastServiceImpl<T extends CommerceMLForecast> {
    protected static final ZoneId DEFAULT_ZONE_OFFSET = ZoneOffset.systemDefault();
    protected static final String SORTABLE_FIELD_SUFFIX = "_sortable";
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    @Reference
    protected volatile SearchEngineAdapter searchEngineAdapter;
    private static final String _INDEX_DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceMLForecastServiceImpl.class);

    protected T addCommerceMLForecast(T model) throws PortalException {
        Document document = this.toDocumentModel(model);
        document.addKeyword("uid", String.valueOf(model.getForecastId()));
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this.getIndexName(model.getCompanyId()), document);
        IndexDocumentResponse indexDocumentResponse = (IndexDocumentResponse)this.searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
        if (indexDocumentResponse.getStatus() < 200 || indexDocumentResponse.getStatus() >= 300) {
            throw new PortalException(String.format("Index request return status: %d", indexDocumentResponse.getStatus()));
        }
        return model;
    }

    protected BooleanQuery getBooleanQuery(final String scope, final String period, final String target) {
        return new BooleanQueryImpl(){
            {
                this.setPreBooleanFilter(BaseCommerceMLForecastServiceImpl.this._getBooleanFilter(scope, period, target));
            }
        };
    }

    protected BooleanQuery getBooleanQuery(final String scope, final String period, final String target, final Date startDate, final Date endDate) throws com.liferay.portal.kernel.search.ParseException {
        return new BooleanQueryImpl(){
            {
                BooleanFilter booleanFilter = BaseCommerceMLForecastServiceImpl.this._getBooleanFilter(scope, period, target);
                booleanFilter.add((Filter)new RangeTermFilter("timestamp", true, true, BaseCommerceMLForecastServiceImpl.this._formatSearchDate(startDate), BaseCommerceMLForecastServiceImpl.this._formatSearchDate(endDate)), BooleanClauseOccur.MUST);
                this.setPreBooleanFilter(booleanFilter);
            }
        };
    }

    protected T getCommerceMLForecast(long companyId, final long forecastId) throws PortalException {
        List<T> searchResults = this.getSearchResults(this.getSearchSearchRequest(this.getIndexName(companyId), (Query)new BooleanQueryImpl(){
            {
                this.setPreBooleanFilter(new BooleanFilter(){
                    {
                        this.add((Filter)new TermFilter("forecastId", String.valueOf(forecastId)), BooleanClauseOccur.MUST);
                    }
                });
            }
        }, 0, 1, this.getDefaultSort(true)));
        if (searchResults.isEmpty()) {
            return null;
        }
        return (T)((CommerceMLForecast)searchResults.get(0));
    }

    protected T getCommerceMLForecastModel(T commerceMLForecast, Document document) {
        block2: {
            commerceMLForecast.setActual(GetterUtil.getFloat((String)document.get("actual"), (float)Float.MIN_VALUE));
            commerceMLForecast.setCompanyId(GetterUtil.getLong((String)document.get("companyId")));
            commerceMLForecast.setForecast(GetterUtil.getFloat((String)document.get("forecast"), (float)Float.MIN_VALUE));
            commerceMLForecast.setForecastId(GetterUtil.getLong((String)document.get("forecastId")));
            commerceMLForecast.setForecastLowerBound(GetterUtil.getFloat((String)document.get("forecastLowerBound")));
            commerceMLForecast.setForecastUpperBound(GetterUtil.getFloat((String)document.get("forecastUpperBound")));
            commerceMLForecast.setJobId(document.get("jobId"));
            commerceMLForecast.setScope(document.get("scope"));
            commerceMLForecast.setPeriod(document.get("period"));
            commerceMLForecast.setTarget(document.get("target"));
            try {
                commerceMLForecast.setTimestamp(document.getDate("timestamp"));
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)parseException);
            }
        }
        return commerceMLForecast;
    }

    protected long getCountResult(CountSearchRequest countSearchRequest) {
        CountSearchResponse countSearchResponse = (CountSearchResponse)this.searchEngineAdapter.execute((SearchRequest)countSearchRequest);
        return countSearchResponse.getCount();
    }

    protected CountSearchRequest getCountSearchRequest(final String indexName, final Query query) {
        return new CountSearchRequest(){
            {
                this.setIndexNames(new String[]{indexName});
                this.setQuery(query);
            }
        };
    }

    protected Sort[] getDefaultSort(boolean reverse) {
        Sort sort = SortFactoryUtil.create((String)"timestamp".concat(SORTABLE_FIELD_SUFFIX), (boolean)reverse);
        return new Sort[]{sort};
    }

    protected Document getDocument(T commerceMLForecast) {
        DocumentImpl document = new DocumentImpl();
        document.addNumber("actual", commerceMLForecast.getActual());
        document.addNumber("companyId", commerceMLForecast.getCompanyId());
        document.addNumber("forecast", commerceMLForecast.getForecast());
        document.addNumber("forecastId", commerceMLForecast.getForecastId());
        document.addNumber("forecastLowerBound", commerceMLForecast.getForecastLowerBound());
        document.addNumber("forecastUpperBound", commerceMLForecast.getForecastUpperBound());
        document.addText("jobId", commerceMLForecast.getJobId());
        document.addText("period", commerceMLForecast.getPeriod());
        document.addText("scope", commerceMLForecast.getScope());
        document.addText("target", commerceMLForecast.getTarget());
        document.addDate("timestamp", commerceMLForecast.getTimestamp());
        return document;
    }

    protected Date getEndDate(Date endDate, CommerceMLForecastPeriod commerceMLForecastPeriod, int stepCount) {
        LocalDateTime endLocalDateTime = LocalDateTime.ofInstant(endDate.toInstant(), DEFAULT_ZONE_OFFSET);
        endLocalDateTime = endLocalDateTime.truncatedTo(ChronoUnit.DAYS);
        if (commerceMLForecastPeriod.equals((Object)CommerceMLForecastPeriod.MONTH)) {
            endLocalDateTime = endLocalDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
            endLocalDateTime = endLocalDateTime.plusMonths(stepCount);
        } else {
            endLocalDateTime = endLocalDateTime.with(ChronoField.DAY_OF_WEEK, 1L);
            endLocalDateTime = endLocalDateTime.plusWeeks(stepCount);
        }
        return this._toDate(endLocalDateTime);
    }

    protected long getHash(Object ... values) {
        StringBundler sb = new StringBundler(values.length);
        for (Object value : values) {
            sb.append(value);
        }
        return HashUtil.hash((int)values.length, (Object)sb.toString());
    }

    protected String getIndexName(long companyId) {
        return IndexNamePatterns.getIndexName(this.indexNameBuilder, "%s-commerce-ml-forecast", companyId);
    }

    protected List<T> getSearchResults(SearchSearchRequest searchSearchRequest) {
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        return TransformUtil.transform(this._getDocuments(searchSearchResponse.getHits()), this::toForecastModel);
    }

    protected SearchSearchRequest getSearchSearchRequest(final String indexName, final Query query, final int start, final int size, final Sort[] sorts) {
        return new SearchSearchRequest(){
            {
                this.setIndexNames(new String[]{indexName});
                this.setQuery(query);
                this.setSize(size);
                this.setSorts(sorts);
                this.setStart(start);
                this.setStats(Collections.emptyMap());
            }
        };
    }

    protected Date getStartDate(Date startDate, CommerceMLForecastPeriod commerceMLForecastPeriod, int stepCount) {
        LocalDateTime startLocalDateTime = LocalDateTime.ofInstant(startDate.toInstant(), DEFAULT_ZONE_OFFSET);
        startLocalDateTime = startLocalDateTime.truncatedTo(ChronoUnit.DAYS);
        if (commerceMLForecastPeriod.equals((Object)CommerceMLForecastPeriod.MONTH)) {
            startLocalDateTime = startLocalDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
            startLocalDateTime = startLocalDateTime.minusMonths(stepCount);
        } else {
            startLocalDateTime = startLocalDateTime.with(ChronoField.DAY_OF_WEEK, 1L);
            startLocalDateTime = startLocalDateTime.minusWeeks(stepCount);
        }
        return this._toDate(startLocalDateTime);
    }

    protected abstract Document toDocumentModel(T var1);

    protected abstract T toForecastModel(Document var1);

    private String _formatSearchDate(Date searchDate) {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_INDEX_DATE_FORMAT_PATTERN);
        return dateFormat.format(searchDate);
    }

    private BooleanFilter _getBooleanFilter(final String scope, final String period, final String target) {
        return new BooleanFilter(){
            {
                this.add((Filter)new TermFilter("period", period), BooleanClauseOccur.MUST);
                this.add((Filter)new TermFilter("scope", scope), BooleanClauseOccur.MUST);
                this.add((Filter)new TermFilter("target", target), BooleanClauseOccur.MUST);
            }
        };
    }

    private List<Document> _getDocuments(Hits hits) {
        ArrayList<Document> list = new ArrayList<Document>(hits.toList());
        Map groupedHits = hits.getGroupedHits();
        for (Map.Entry entry : groupedHits.entrySet()) {
            list.addAll(this._getDocuments((Hits)entry.getValue()));
        }
        return list;
    }

    private Date _toDate(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(DEFAULT_ZONE_OFFSET);
        return Date.from(zonedDateTime.toInstant());
    }
}

