/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.internal.forecast;

import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecastManager;
import com.liferay.commerce.machine.learning.internal.forecast.AssetCategoryCommerceMLForecastImpl;
import com.liferay.commerce.machine.learning.internal.forecast.BaseCommerceMLForecastServiceImpl;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastPeriod;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastScope;
import com.liferay.commerce.machine.learning.internal.forecast.constants.CommerceMLForecastTarget;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(service={AssetCategoryCommerceMLForecastManager.class})
public class AssetCategoryCommerceMLForecastManagerImpl
extends BaseCommerceMLForecastServiceImpl<AssetCategoryCommerceMLForecast>
implements AssetCategoryCommerceMLForecastManager {
    private static final CommerceMLForecastScope _commerceMLForecastScope = CommerceMLForecastScope.ASSET_CATEGORY;

    public AssetCategoryCommerceMLForecast addAssetCategoryCommerceMLForecast(AssetCategoryCommerceMLForecast assetCategoryCommerceMLForecast) throws PortalException {
        long commerceMLForecastId = this.getHash(assetCategoryCommerceMLForecast.getAssetCategoryId(), assetCategoryCommerceMLForecast.getCommerceAccountId(), assetCategoryCommerceMLForecast.getPeriod(), assetCategoryCommerceMLForecast.getScope(), assetCategoryCommerceMLForecast.getTarget(), assetCategoryCommerceMLForecast.getTimestamp());
        assetCategoryCommerceMLForecast.setForecastId(commerceMLForecastId);
        return this.addCommerceMLForecast(assetCategoryCommerceMLForecast);
    }

    public AssetCategoryCommerceMLForecast create() {
        return new AssetCategoryCommerceMLForecastImpl();
    }

    public AssetCategoryCommerceMLForecast getAssetCategoryCommerceMLForecast(long companyId, long forecastId) throws PortalException {
        return (AssetCategoryCommerceMLForecast)this.getCommerceMLForecast(companyId, forecastId);
    }

    public List<AssetCategoryCommerceMLForecast> getMonthlyRevenueAssetCategoryCommerceMLForecasts(long companyId, long[] assetCategoryIds, long[] commerceAccountIds, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        int size = assetCategoryIds.length * commerceAccountIds.length * (historyLength + forecastLength);
        return this.getMonthlyRevenueAssetCategoryCommerceMLForecasts(companyId, assetCategoryIds, commerceAccountIds, actualDate, historyLength, forecastLength, 0, size);
    }

    public List<AssetCategoryCommerceMLForecast> getMonthlyRevenueAssetCategoryCommerceMLForecasts(long companyId, long[] assetCategoryIds, long[] commerceAccountIds, Date actualDate, int historyLength, int forecastLength, int start, int end) throws PortalException {
        return this.getSearchResults(this.getSearchSearchRequest(this.getIndexName(companyId), this._getMonthlyRevenueQuery(actualDate, assetCategoryIds, commerceAccountIds, historyLength, forecastLength), start, end - start, this.getDefaultSort(true)));
    }

    public long getMonthlyRevenueAssetCategoryCommerceMLForecastsCount(long companyId, long[] assetCategoryIds, long[] commerceAccountIds, Date actualDate, int historyLength, int forecastLength) throws PortalException {
        return this.getCountResult(this.getCountSearchRequest(this.getIndexName(companyId), this._getMonthlyRevenueQuery(actualDate, assetCategoryIds, commerceAccountIds, historyLength, forecastLength)));
    }

    @Override
    protected Document toDocumentModel(AssetCategoryCommerceMLForecast assetCategoryCommerceMLForecast) {
        Document document = this.getDocument(assetCategoryCommerceMLForecast);
        document.addNumber("commerceAccountId", assetCategoryCommerceMLForecast.getCommerceAccountId());
        document.addNumber("assetCategoryId", assetCategoryCommerceMLForecast.getAssetCategoryId());
        return document;
    }

    @Override
    protected AssetCategoryCommerceMLForecast toForecastModel(Document document) {
        AssetCategoryCommerceMLForecast assetCategoryCommerceMLForecast = this.getCommerceMLForecastModel(new AssetCategoryCommerceMLForecastImpl(), document);
        assetCategoryCommerceMLForecast.setAssetCategoryId(GetterUtil.getLong((String)document.get("assetCategoryId")));
        assetCategoryCommerceMLForecast.setCommerceAccountId(GetterUtil.getLong((String)document.get("commerceAccountId")));
        return assetCategoryCommerceMLForecast;
    }

    private Query _getMonthlyRevenueQuery(Date actualDate, final long[] assetCategoryIds, final long[] commerceAccountIds, int historyLength, int forecastLength) throws ParseException {
        CommerceMLForecastPeriod commerceMLForecastPeriod = CommerceMLForecastPeriod.MONTH;
        CommerceMLForecastTarget commerceMLForecastTarget = CommerceMLForecastTarget.REVENUE;
        BooleanQuery booleanQuery = this.getBooleanQuery(_commerceMLForecastScope.getLabel(), commerceMLForecastPeriod.getLabel(), commerceMLForecastTarget.getLabel(), this.getStartDate(actualDate, commerceMLForecastPeriod, historyLength), this.getEndDate(actualDate, commerceMLForecastPeriod, forecastLength));
        BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
        if (assetCategoryIds.length > 0) {
            preBooleanFilter.add((Filter)new TermsFilter("assetCategoryId"){
                {
                    super(x0);
                    this.addValues(ArrayUtil.toStringArray((long[])assetCategoryIds));
                }
            }, BooleanClauseOccur.MUST);
        }
        preBooleanFilter.add((Filter)new TermsFilter("commerceAccountId"){
            {
                super(x0);
                this.addValues(ArrayUtil.toStringArray((long[])commerceAccountIds));
            }
        }, BooleanClauseOccur.MUST);
        return booleanQuery;
    }
}

