/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserIdMapperLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceUsersImporter.class})
public class CommerceUsersImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceUsersImporter.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private File _file;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserIdMapperLocalService _userIdMapperLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommerceUsers(java.io.File commerceUsersFile, ClassLoader classLoader, String imageDependenciesPath, long scopeGroupId, long userId) throws Exception {
        MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
        JsonParser jsonFactoryParser = mappingJsonFactory.createParser(commerceUsersFile);
        JsonToken jsonToken = jsonFactoryParser.nextToken();
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new Exception("JSON Array Expected");
        }
        ServiceContext serviceContext = this.getServiceContext(scopeGroupId, userId);
        int importCount = 0;
        while (jsonFactoryParser.nextToken() != JsonToken.END_ARRAY) {
            TreeNode treeNode = jsonFactoryParser.readValueAsTree();
            JSONObject jsonObject = this._jsonFactory.createJSONObject(treeNode.toString());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonObject);
            }
            this._importCommerceUser(jsonObject, classLoader, imageDependenciesPath, serviceContext);
            ++importCount;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Imported users count: " + importCount));
        }
        jsonFactoryParser.close();
    }

    public void importCommerceUsers(JSONArray jsonArray, ClassLoader classLoader, String dependenciesPath, long scopeGroupId, long userId) throws IOException, PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importCommerceUser(jsonArray.getJSONObject(i), classLoader, dependenciesPath, serviceContext);
        }
    }

    protected User addOrUpdateUser(String password, String userReminderQueryQuestion, String userReminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean portrait, byte[] portraitBytes, Locale locale, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixListTypeId, long suffixListTypeId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.fetchUserByScreenName(serviceContext.getCompanyId(), screenName);
        if (user == null) {
            user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), emailAddress);
        }
        long companyId = serviceContext.getCompanyId();
        long creatorUserId = serviceContext.getUserId();
        boolean autoScreenName = Validator.isNull((String)screenName);
        if (user == null) {
            boolean autoPassword = Validator.isNull((String)password);
            user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password, password, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, 1, groupIds, organizationIds, roleIds, userGroupIds, false, serviceContext);
        } else {
            groupIds = ArrayUtil.append((long[][])new long[][]{user.getGroupIds(), groupIds});
        }
        if (Validator.isNotNull((String)comments) || !groupIds.equals(user.getGroupIds())) {
            user = this._userLocalService.updateUser(user.getUserId(), "", "", "", false, userReminderQueryQuestion, userReminderQueryAnswer, screenName, emailAddress, portrait, portraitBytes, LocaleUtil.toLanguageId((Locale)locale), timeZoneId, greeting, comments, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, null, userGroupIds, serviceContext);
        } else if (portrait) {
            this._userLocalService.updatePortrait(user.getUserId(), portraitBytes);
        }
        return user;
    }

    protected ServiceContext getServiceContext(long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private void _importCommerceUser(JSONObject jsonObject, ClassLoader classLoader, String dependenciesPath, ServiceContext serviceContext) throws IOException, PortalException {
        JSONArray accountsJSONArray;
        String password = jsonObject.getString("password");
        String userReminderQueryQuestion = jsonObject.getString("userReminderQueryQuestion");
        String userReminderQueryAnswer = jsonObject.getString("userReminderQueryAnswer");
        String screenName = jsonObject.getString("screenName");
        long facebookId = jsonObject.getLong("facebookId");
        String openId = jsonObject.getString("openId");
        String emailAddress = jsonObject.getString("emailAddress");
        boolean hasPortrait = false;
        byte[] portraitBytes = null;
        String portrait = jsonObject.getString("portrait");
        if (!Validator.isBlank((String)portrait)) {
            try (InputStream inputStream = null;){
                String uriString = dependenciesPath + URLEncoder.encode(portrait, "UTF-8");
                URI uri = new URI(uriString);
                inputStream = StringUtil.equalsIgnoreCase((String)uri.getScheme(), (String)"file") ? new FileInputStream(uri.getPath()) : classLoader.getResourceAsStream(dependenciesPath + portrait);
                portraitBytes = this._file.getBytes(inputStream);
                hasPortrait = true;
            }
        }
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Locale locale = user.getLocale();
        String importedLanguageCode = jsonObject.getString("languageCode");
        if (!Validator.isBlank((String)importedLanguageCode)) {
            locale = this._language.getLocale(importedLanguageCode);
        }
        TimeZone timeZone = user.getTimeZone();
        String timeZoneId = jsonObject.getString("timeZoneId", timeZone.getID());
        String greeting = jsonObject.getString("greeting");
        String comments = jsonObject.getString("comments");
        String firstName = jsonObject.getString("firstName");
        String middleName = jsonObject.getString("middleName");
        String lastName = jsonObject.getString("lastName");
        long prefixListTypeId = jsonObject.getLong("prefixListTypeId");
        long suffixListTypeId = jsonObject.getLong("suffixListTypeId");
        boolean male = jsonObject.getBoolean("male");
        String gender = jsonObject.getString("gender");
        if (Validator.isNotNull((String)gender)) {
            male = gender.equals("male");
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
        int birthdayMonth = calendar.get(jsonObject.getInt("birthdayMonth", 2));
        int birthdayDay = calendar.get(jsonObject.getInt("birthdayDay", 5));
        int birthdayYear = calendar.get(jsonObject.getInt("birthdayYear", 1));
        String birthday = jsonObject.getString("birthday");
        if (Validator.isNotNull((String)birthday)) {
            String[] birthdayTokens = birthday.split("-");
            birthdayMonth = GetterUtil.getInteger((String)birthdayTokens[1]) - 1;
            birthdayDay = GetterUtil.getInteger((String)birthdayTokens[2]);
            birthdayYear = GetterUtil.getInteger((String)birthdayTokens[0]);
        }
        String smsSn = jsonObject.getString("smsSn");
        String facebookSn = jsonObject.getString("facebookSn");
        String jabberSn = jsonObject.getString("jabberSn");
        String skypeSn = jsonObject.getString("skypeSn");
        String twitterSn = jsonObject.getString("twitterSn");
        String jobTitle = jsonObject.getString("jobTitle");
        JSONArray organizationsJSONArray = jsonObject.getJSONArray("organizations");
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        if (organizationsJSONArray != null) {
            for (int i = 0; i < organizationsJSONArray.length(); ++i) {
                Organization organization = this._organizationLocalService.getOrganization(serviceContext.getCompanyId(), organizationsJSONArray.getString(i));
                if (organization == null) continue;
                organizationIds.add(organization.getOrganizationId());
            }
        }
        JSONArray rolesJSONArray = jsonObject.getJSONArray("roles");
        ArrayList<Long> roleIds = new ArrayList<Long>();
        if (rolesJSONArray != null) {
            for (int i = 0; i < rolesJSONArray.length(); ++i) {
                Role role = this._roleLocalService.getRole(serviceContext.getCompanyId(), rolesJSONArray.getString(i));
                if (role == null) continue;
                roleIds.add(role.getRoleId());
            }
        }
        long[] userGroupIds = null;
        user = this.addOrUpdateUser(password, userReminderQueryQuestion, userReminderQueryAnswer, screenName, emailAddress, facebookId, openId, hasPortrait, portraitBytes, locale, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, new long[]{serviceContext.getScopeGroupId()}, ArrayUtil.toLongArray(organizationIds), ArrayUtil.toLongArray(roleIds), userGroupIds, serviceContext);
        JSONArray groupRolesJSONArray = jsonObject.getJSONArray("groupRoles");
        if (groupRolesJSONArray != null) {
            for (int i = 0; i < groupRolesJSONArray.length(); ++i) {
                Role role = this._roleLocalService.getRole(serviceContext.getCompanyId(), groupRolesJSONArray.getString(i));
                this._userGroupRoleLocalService.addUserGroupRoles(user.getUserId(), serviceContext.getScopeGroupId(), new long[]{role.getRoleId()});
            }
        }
        String externalUserId = jsonObject.getString("externalUserId");
        String externalSystemType = jsonObject.getString("externalSystemType");
        if (Validator.isNotNull((String)externalUserId) && Validator.isNotNull((String)externalSystemType)) {
            String externalSystemDescription = jsonObject.getString("externalSystemDescription", "");
            this._userIdMapperLocalService.updateUserIdMapper(user.getUserId(), externalSystemType, externalSystemDescription, externalUserId);
        }
        if ((accountsJSONArray = jsonObject.getJSONArray("accounts")) != null) {
            for (int i = 0; i < accountsJSONArray.length(); ++i) {
                AccountEntry accountEntry;
                AccountEntryUserRel accountEntryUserRel;
                JSONObject accountJSONObject = accountsJSONArray.getJSONObject(i);
                JSONArray accountRolesJSONArray = accountJSONObject.getJSONArray("roles");
                if (accountRolesJSONArray == null || (accountEntryUserRel = this._accountEntryUserRelLocalService.fetchAccountEntryUserRel((accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(this._friendlyURLNormalizer.normalize(accountJSONObject.getString("name")), serviceContext.getCompanyId())).getAccountEntryId(), user.getUserId())) != null) continue;
                ArrayList<Long> accountRoleIds = new ArrayList<Long>();
                for (int j = 0; j < accountRolesJSONArray.length(); ++j) {
                    Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), accountRolesJSONArray.getString(j));
                    if (role == null) continue;
                    accountRoleIds.add(role.getRoleId());
                }
                long[] userIds = new long[]{user.getUserId()};
                this._commerceAccountHelper.addAccountEntryUserRels(accountEntry.getAccountEntryId(), userIds, null, ArrayUtil.toLongArray(accountRoleIds), serviceContext);
            }
        }
    }
}

